/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.stream;

import com.timeplus.data.Block;
import com.timeplus.misc.CheckedIterator;
import com.timeplus.misc.CheckedSupplier;
import com.timeplus.protocol.DataResponse;
import com.timeplus.protocol.EOFStreamResponse;
import com.timeplus.protocol.ProgressResponse;
import com.timeplus.protocol.Response;
import com.timeplus.protocol.listener.ProgressListener;
import com.timeplus.stream.QueryResult;
import java.sql.SQLException;

public class TimeplusQueryResult
implements QueryResult {
    private final CheckedSupplier<Response, SQLException> responseSupplier;
    private ProgressListener progressListener;
    private Block header;
    private boolean atEnd;

    public TimeplusQueryResult(CheckedSupplier<Response, SQLException> responseSupplier) {
        this.responseSupplier = responseSupplier;
    }

    public TimeplusQueryResult(CheckedSupplier<Response, SQLException> responseSupplier, ProgressListener progressListener) {
        this.progressListener = progressListener;
        this.responseSupplier = responseSupplier;
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    @Override
    public Block header() throws SQLException {
        this.ensureHeaderConsumed();
        return this.header;
    }

    @Override
    public CheckedIterator<DataResponse, SQLException> data() {
        return new CheckedIterator<DataResponse, SQLException>(){
            private DataResponse current;

            @Override
            public boolean hasNext() throws SQLException {
                return this.current != null || this.fill() != null;
            }

            @Override
            public DataResponse next() throws SQLException {
                return this.drain();
            }

            private DataResponse fill() throws SQLException {
                TimeplusQueryResult.this.ensureHeaderConsumed();
                this.current = TimeplusQueryResult.this.consumeDataResponse();
                return this.current;
            }

            private DataResponse drain() throws SQLException {
                if (this.current == null) {
                    this.fill();
                }
                DataResponse top = this.current;
                this.current = null;
                return top;
            }
        };
    }

    private void ensureHeaderConsumed() throws SQLException {
        if (this.header == null) {
            DataResponse firstDataResponse = this.consumeDataResponse();
            this.header = firstDataResponse != null ? firstDataResponse.block() : new Block();
        }
    }

    private DataResponse consumeDataResponse() throws SQLException {
        long readRows = 0L;
        long readBytes = 0L;
        while (!this.atEnd) {
            Response response = this.responseSupplier.get();
            if (response instanceof DataResponse) {
                DataResponse dataResponse = (DataResponse)response;
                dataResponse.block().setProgress(readRows, readBytes);
                return dataResponse;
            }
            if (response instanceof EOFStreamResponse || response == null) {
                this.atEnd = true;
                continue;
            }
            if (!(response instanceof ProgressResponse)) continue;
            if (this.progressListener != null) {
                this.progressListener.onProgress((ProgressResponse)response);
            }
            readRows += ((ProgressResponse)response).newRows();
            readBytes += ((ProgressResponse)response).newBytes();
        }
        return null;
    }
}

