/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.stream;

import com.timeplus.client.NativeContext;
import com.timeplus.data.Block;
import com.timeplus.data.ColumnFactory;
import com.timeplus.data.DataTypeFactory;
import com.timeplus.data.IColumn;
import com.timeplus.data.IDataType;
import com.timeplus.misc.CheckedIterator;
import com.timeplus.misc.Validate;
import com.timeplus.protocol.DataResponse;
import com.timeplus.stream.QueryResult;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;

public class QueryResultBuilder {
    private final int columnNum;
    private final NativeContext.ServerContext serverContext;
    private List<String> columnNames;
    private List<IDataType> columnTypes;
    private final List<List<?>> rows = new ArrayList();

    public static QueryResultBuilder builder(int columnsNum, NativeContext.ServerContext serverContext) {
        return new QueryResultBuilder(columnsNum, serverContext);
    }

    private QueryResultBuilder(int columnNum, NativeContext.ServerContext serverContext) {
        this.columnNum = columnNum;
        this.serverContext = serverContext;
    }

    public QueryResultBuilder columnNames(String ... names) {
        return this.columnNames(Arrays.asList(names));
    }

    public QueryResultBuilder columnNames(List<String> names) {
        Validate.ensure(names.size() == this.columnNum, "size mismatch, req: " + this.columnNum + " got: " + names.size());
        this.columnNames = names;
        return this;
    }

    public QueryResultBuilder columnTypes(String ... types) throws SQLException {
        return this.columnTypes(Arrays.asList(types));
    }

    public QueryResultBuilder columnTypes(List<String> types) throws SQLException {
        Validate.ensure(types.size() == this.columnNum, "size mismatch, req: " + this.columnNum + " got: " + types.size());
        this.columnTypes = new ArrayList<IDataType>(this.columnNum);
        for (int i = 0; i < this.columnNum; ++i) {
            this.columnTypes.add(DataTypeFactory.get(types.get(i), this.serverContext));
        }
        return this;
    }

    public QueryResultBuilder addRow(Object ... row) {
        return this.addRow(Arrays.asList(row));
    }

    public QueryResultBuilder addRow(List<?> row) {
        Validate.ensure(row.size() == this.columnNum, "size mismatch, req: " + this.columnNum + " got: " + row.size());
        this.rows.add(row);
        return this;
    }

    public QueryResult build() throws SQLException {
        Validate.ensure(this.columnNames != null, "columnNames is null");
        Validate.ensure(this.columnTypes != null, "columnTypes is null");
        IColumn[] headerColumns = new IColumn[this.columnNum];
        Object[] emptyObjects = new Object[this.columnNum];
        for (int c = 0; c < this.columnNum; ++c) {
            headerColumns[c] = ColumnFactory.createColumn(this.columnNames.get(c), this.columnTypes.get(c), emptyObjects);
        }
        final Block headerBlock = new Block(0, headerColumns);
        IColumn[] dataColumns = new IColumn[this.columnNum];
        for (int c = 0; c < this.columnNum; ++c) {
            Object[] columnObjects = new Object[this.rows.size()];
            for (int r = 0; r < this.rows.size(); ++r) {
                columnObjects[r] = this.rows.get(r).get(c);
            }
            dataColumns[c] = ColumnFactory.createColumn(this.columnNames.get(c), this.columnTypes.get(c), columnObjects);
        }
        final Block dataBlock = new Block(this.rows.size(), dataColumns);
        return new QueryResult(){

            @Override
            public Block header() throws SQLException {
                return headerBlock;
            }

            @Override
            public CheckedIterator<DataResponse, SQLException> data() {
                final DataResponse data = new DataResponse("client_build", dataBlock);
                return new CheckedIterator<DataResponse, SQLException>(){
                    private final DataResponse dataResponse;
                    private boolean beforeFirst;
                    {
                        this.dataResponse = data;
                        this.beforeFirst = true;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.beforeFirst;
                    }

                    @Override
                    public DataResponse next() {
                        if (!this.beforeFirst) {
                            throw new NoSuchElementException();
                        }
                        this.beforeFirst = false;
                        return this.dataResponse;
                    }
                };
            }
        };
    }
}

