/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.serde;

import com.timeplus.buffer.BuffedWriter;
import com.timeplus.buffer.CompressedBuffedWriter;
import com.timeplus.misc.Switcher;
import com.timeplus.settings.TimeplusDefines;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class BinarySerializer {
    private final Switcher<BuffedWriter> switcher;
    private final boolean enableCompress;
    private final byte[] writeBuffer;

    public BinarySerializer(BuffedWriter writer, boolean enableCompress) {
        this.enableCompress = enableCompress;
        CompressedBuffedWriter compressWriter = null;
        if (enableCompress) {
            compressWriter = new CompressedBuffedWriter(TimeplusDefines.SOCKET_SEND_BUFFER_BYTES, writer);
        }
        this.switcher = new Switcher<BuffedWriter>(compressWriter, writer);
        this.writeBuffer = new byte[32];
    }

    public void writeVarInt(long x) throws IOException {
        for (int i = 0; i < 9; ++i) {
            byte byt = (byte)(x & 0x7FL);
            if (x > 127L) {
                byt = (byte)(byt | 0x80);
            }
            this.switcher.get().writeBinary(byt);
            if ((x >>= 7) != 0L) continue;
            return;
        }
    }

    public void writeByte(byte x) throws IOException {
        this.switcher.get().writeBinary(x);
    }

    public void writeBoolean(boolean x) throws IOException {
        this.writeVarInt((byte)(x ? 1 : 0));
    }

    public void writeShort(short i) throws IOException {
        this.writeBuffer[0] = (byte)(i >> 0 & 0xFF);
        this.writeBuffer[1] = (byte)(i >> 8 & 0xFF);
        this.switcher.get().writeBinary(this.writeBuffer, 0, 2);
    }

    public void writeInt(int i) throws IOException {
        this.writeBuffer[0] = (byte)(i >> 0 & 0xFF);
        this.writeBuffer[1] = (byte)(i >> 8 & 0xFF);
        this.writeBuffer[2] = (byte)(i >> 16 & 0xFF);
        this.writeBuffer[3] = (byte)(i >> 24 & 0xFF);
        this.switcher.get().writeBinary(this.writeBuffer, 0, 4);
    }

    public void writeLong(long i) throws IOException {
        this.writeBuffer[0] = (byte)(i >> 0 & 0xFFL);
        this.writeBuffer[1] = (byte)(i >> 8 & 0xFFL);
        this.writeBuffer[2] = (byte)(i >> 16 & 0xFFL);
        this.writeBuffer[3] = (byte)(i >> 24 & 0xFFL);
        this.writeBuffer[4] = (byte)(i >> 32 & 0xFFL);
        this.writeBuffer[5] = (byte)(i >> 40 & 0xFFL);
        this.writeBuffer[6] = (byte)(i >> 48 & 0xFFL);
        this.writeBuffer[7] = (byte)(i >> 56 & 0xFFL);
        this.switcher.get().writeBinary(this.writeBuffer, 0, 8);
    }

    public void writeBigInteger(BigInteger value, int length) throws IOException {
        int j;
        int empty = value.signum() == -1 ? -1 : 0;
        byte[] bytes = value.toByteArray();
        int endIndex = bytes.length == length + 1 && bytes[0] == 0 ? 1 : 0;
        int Index = 0;
        for (j = bytes.length - 1; j >= endIndex; --j) {
            this.writeBuffer[Index++] = bytes[j];
        }
        for (j = length - bytes.length; j > 0; --j) {
            this.writeBuffer[Index++] = empty;
        }
        this.switcher.get().writeBinary(this.writeBuffer, 0, length);
    }

    public void writeUTF8StringBinary(String utf8) throws IOException {
        this.writeStringBinary(utf8, StandardCharsets.UTF_8);
    }

    public void writeStringBinary(String data, Charset charset) throws IOException {
        byte[] bs = data.getBytes(charset);
        this.writeBytesBinary(bs);
    }

    public void writeBytesBinary(byte[] bs) throws IOException {
        this.writeVarInt(bs.length);
        this.switcher.get().writeBinary(bs, 0, bs.length);
    }

    public void flushToTarget(boolean force) throws IOException {
        this.switcher.get().flushToTarget(force);
    }

    public void maybeEnableCompressed() {
        if (this.enableCompress) {
            this.switcher.select(false);
        }
    }

    public void maybeDisableCompressed() throws IOException {
        if (this.enableCompress) {
            this.switcher.get().flushToTarget(true);
            this.switcher.select(true);
        }
    }

    public void writeFloat(float datum) throws IOException {
        int x = Float.floatToIntBits(datum);
        this.writeInt(x);
    }

    public void writeDouble(double datum) throws IOException {
        long x = Double.doubleToLongBits(datum);
        this.writeBuffer[0] = (byte)(x >>> 0 & 0xFFL);
        this.writeBuffer[1] = (byte)(x >>> 8 & 0xFFL);
        this.writeBuffer[2] = (byte)(x >>> 16 & 0xFFL);
        this.writeBuffer[3] = (byte)(x >>> 24 & 0xFFL);
        this.writeBuffer[4] = (byte)(x >>> 32 & 0xFFL);
        this.writeBuffer[5] = (byte)(x >>> 40 & 0xFFL);
        this.writeBuffer[6] = (byte)(x >>> 48 & 0xFFL);
        this.writeBuffer[7] = (byte)(x >>> 56 & 0xFFL);
        this.switcher.get().writeBinary(this.writeBuffer, 0, 8);
    }

    public void writeBytes(byte[] bytes) throws IOException {
        this.writeBytes(bytes, 0, bytes.length);
    }

    public void writeBytes(byte[] bytes, int offset, int length) throws IOException {
        this.switcher.get().writeBinary(bytes, offset, length);
    }
}

