/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.protocol;

import com.timeplus.client.NativeContext;
import com.timeplus.exception.NotImplementedException;
import com.timeplus.protocol.DataResponse;
import com.timeplus.protocol.EOFStreamResponse;
import com.timeplus.protocol.ExceptionResponse;
import com.timeplus.protocol.ExtremesResponse;
import com.timeplus.protocol.HelloResponse;
import com.timeplus.protocol.PongResponse;
import com.timeplus.protocol.ProfileInfoResponse;
import com.timeplus.protocol.ProgressResponse;
import com.timeplus.protocol.TotalsResponse;
import com.timeplus.serde.BinaryDeserializer;
import java.io.IOException;
import java.sql.SQLException;

public interface Response {
    public ProtoType type();

    public static Response readFrom(BinaryDeserializer deserializer, NativeContext.ServerContext info) throws IOException, SQLException {
        switch ((int)deserializer.readVarInt()) {
            case 0: {
                return HelloResponse.readFrom(deserializer);
            }
            case 1: {
                return DataResponse.readFrom(deserializer, info);
            }
            case 2: {
                throw ExceptionResponse.readExceptionFrom(deserializer);
            }
            case 3: {
                return ProgressResponse.readFrom(deserializer);
            }
            case 4: {
                return PongResponse.readFrom(deserializer);
            }
            case 5: {
                return EOFStreamResponse.readFrom(deserializer);
            }
            case 6: {
                return ProfileInfoResponse.readFrom(deserializer);
            }
            case 7: {
                return TotalsResponse.readFrom(deserializer, info);
            }
            case 8: {
                return ExtremesResponse.readFrom(deserializer, info);
            }
            case 9: {
                throw new NotImplementedException("RESPONSE_TABLES_STATUS_RESPONSE");
            }
        }
        throw new IllegalStateException("Accept the id of response that is not recognized by Server.");
    }

    public static enum ProtoType {
        RESPONSE_HELLO(0),
        RESPONSE_DATA(1),
        RESPONSE_EXCEPTION(2),
        RESPONSE_PROGRESS(3),
        RESPONSE_PONG(4),
        RESPONSE_END_OF_STREAM(5),
        RESPONSE_PROFILE_INFO(6),
        RESPONSE_TOTALS(7),
        RESPONSE_EXTREMES(8),
        RESPONSE_TABLES_STATUS_RESPONSE(9);

        private final int id;

        private ProtoType(int id) {
            this.id = id;
        }

        public long id() {
            return this.id;
        }
    }
}

