/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.protocol;

import com.timeplus.protocol.Response;
import com.timeplus.serde.BinaryDeserializer;
import java.io.IOException;
import java.time.ZoneId;

public class HelloResponse
implements Response {
    private final long majorVersion;
    private final long minorVersion;
    private final long reversion;
    private final String serverName;
    private final String serverTimeZone;
    private final String serverDisplayName;

    public static HelloResponse readFrom(BinaryDeserializer deserializer) throws IOException {
        String name = deserializer.readUTF8StringBinary();
        long majorVersion = deserializer.readVarInt();
        long minorVersion = deserializer.readVarInt();
        long serverReversion = deserializer.readVarInt();
        String serverTimeZone = HelloResponse.getTimeZone(deserializer, serverReversion);
        String serverDisplayName = HelloResponse.getDisplayName(deserializer, serverReversion);
        return new HelloResponse(name, majorVersion, minorVersion, serverReversion, serverTimeZone, serverDisplayName);
    }

    private static String getTimeZone(BinaryDeserializer deserializer, long serverReversion) throws IOException {
        return serverReversion >= 54058L ? deserializer.readUTF8StringBinary() : ZoneId.systemDefault().getId();
    }

    private static String getDisplayName(BinaryDeserializer deserializer, long serverReversion) throws IOException {
        return serverReversion >= 54372L ? deserializer.readUTF8StringBinary() : "localhost";
    }

    public HelloResponse(String serverName, long majorVersion, long minorVersion, long reversion, String serverTimeZone, String serverDisplayName) {
        this.reversion = reversion;
        this.serverName = serverName;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.serverTimeZone = serverTimeZone;
        this.serverDisplayName = serverDisplayName;
    }

    @Override
    public Response.ProtoType type() {
        return Response.ProtoType.RESPONSE_HELLO;
    }

    public long majorVersion() {
        return this.majorVersion;
    }

    public long minorVersion() {
        return this.minorVersion;
    }

    public long reversion() {
        return this.reversion;
    }

    public String serverName() {
        return this.serverName;
    }

    public String serverTimeZone() {
        return this.serverTimeZone;
    }

    public String serverDisplayName() {
        return this.serverDisplayName;
    }
}

