/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.misc;

import com.timeplus.exception.InvalidOperationException;
import com.timeplus.misc.Either;
import java.util.Locale;
import java.util.function.Function;

public class Right<L, R>
implements Either<L, R> {
    private final R value;

    Right(R value) {
        this.value = value;
    }

    @Override
    public boolean isRight() {
        return true;
    }

    @Override
    public <R1> Either<L, R1> map(Function<R, R1> f) {
        return Either.right(f.apply(this.value));
    }

    @Override
    public <R1> Either<L, R1> flatMap(Function<R, Either<L, R1>> f) {
        return f.apply(this.value);
    }

    @Override
    public L getLeft() {
        throw new InvalidOperationException("Right not support #getLeft");
    }

    @Override
    public R getRight() {
        return this.value;
    }

    public String toString() {
        return String.format(Locale.ROOT, "Right(%s)", this.value);
    }
}

