/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.misc;

import com.timeplus.exception.InvalidOperationException;
import com.timeplus.misc.Either;
import java.util.Locale;
import java.util.function.Function;

public class Left<L, R>
implements Either<L, R> {
    private final L value;

    Left(L value) {
        this.value = value;
    }

    @Override
    public boolean isRight() {
        return false;
    }

    @Override
    public <R1> Either<L, R1> map(Function<R, R1> f) {
        return Either.left(this.value);
    }

    @Override
    public <R1> Either<L, R1> flatMap(Function<R, Either<L, R1>> f) {
        return Either.left(this.value);
    }

    @Override
    public L getLeft() {
        return this.value;
    }

    @Override
    public R getRight() {
        throw new InvalidOperationException("Left not support #getRight");
    }

    public String toString() {
        return String.format(Locale.ROOT, "Left(%s)", this.value);
    }
}

