/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.misc;

import com.timeplus.exception.TimeplusException;
import com.timeplus.exception.TimeplusSQLException;
import com.timeplus.settings.TimeplusErrCode;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class ExceptionUtil {
    public static RuntimeException unchecked(Exception checked) {
        return new RuntimeException(checked);
    }

    public static <T, R> Function<T, R> unchecked(CheckedFunction<T, R> checked) {
        return t -> {
            try {
                return checked.apply(t);
            }
            catch (Exception rethrow) {
                throw ExceptionUtil.unchecked(rethrow);
            }
        };
    }

    public static <T, U, R> BiFunction<T, U, R> unchecked(CheckedBiFunction<T, U, R> checked) {
        return (t, u) -> {
            try {
                return checked.apply(t, u);
            }
            catch (Exception rethrow) {
                throw ExceptionUtil.unchecked(rethrow);
            }
        };
    }

    public static <T> Supplier<T> unchecked(CheckedSupplier<T> checked) {
        return () -> {
            try {
                return checked.get();
            }
            catch (Exception rethrow) {
                throw ExceptionUtil.unchecked(rethrow);
            }
        };
    }

    public static void rethrowSQLException(CheckedRunnable checked) throws TimeplusSQLException {
        try {
            checked.run();
        }
        catch (Exception rethrow) {
            int errCode = TimeplusErrCode.UNKNOWN_ERROR.code();
            TimeplusException ex = ExceptionUtil.recursiveFind(rethrow, TimeplusException.class);
            if (ex != null) {
                errCode = ex.errCode();
            }
            throw new TimeplusSQLException(errCode, rethrow.getMessage(), (Throwable)rethrow);
        }
    }

    public static <T> T rethrowSQLException(CheckedSupplier<T> checked) throws TimeplusSQLException {
        try {
            return checked.get();
        }
        catch (Exception rethrow) {
            int errCode = TimeplusErrCode.UNKNOWN_ERROR.code();
            TimeplusException ex = ExceptionUtil.recursiveFind(rethrow, TimeplusException.class);
            if (ex != null) {
                errCode = ex.errCode();
            }
            throw new TimeplusSQLException(errCode, rethrow.getMessage(), (Throwable)rethrow);
        }
    }

    @Nullable
    public static <T> T recursiveFind(Throwable th, Class<T> expectedClz) {
        for (Throwable nest = th; nest != null; nest = nest.getCause()) {
            if (!expectedClz.isAssignableFrom(nest.getClass())) continue;
            return (T)nest;
        }
        return null;
    }

    @FunctionalInterface
    public static interface CheckedSupplier<T> {
        public T get() throws Exception;
    }

    @FunctionalInterface
    public static interface CheckedRunnable {
        public void run() throws Exception;
    }

    @FunctionalInterface
    public static interface CheckedBiConsumer<T, U> {
        public void accept(T var1, U var2) throws Exception;
    }

    @FunctionalInterface
    public static interface CheckedBiFunction<T, U, R> {
        public R apply(T var1, U var2) throws Exception;
    }

    @FunctionalInterface
    public static interface CheckedFunction<T, R> {
        public R apply(T var1) throws Exception;
    }
}

