/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.misc;

import com.timeplus.client.NativeContext;
import com.timeplus.settings.SettingKey;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import javax.annotation.Nullable;

public class DateTimeUtil {
    public static ZoneId chooseTimeZone(NativeContext.ServerContext serverContext) {
        return (Boolean)serverContext.getConfigure().settings().getOrDefault(SettingKey.use_client_time_zone, Boolean.valueOf(false)) != false ? ZoneId.systemDefault() : serverContext.timeZone();
    }

    public static LocalDateTime convertTimeZone(LocalDateTime localDateTime, ZoneId from, ZoneId to) {
        return localDateTime.atZone(from).withZoneSameInstant(to).toLocalDateTime();
    }

    public static long toEpochMilli(ZonedDateTime zdt) {
        return zdt.toInstant().toEpochMilli();
    }

    public static long toEpochSecond(ZonedDateTime zdt) {
        return zdt.toInstant().getEpochSecond();
    }

    public static ZonedDateTime toZonedDateTime(long seconds, int nanos, ZoneId tz) {
        Instant i = Instant.ofEpochSecond(seconds, nanos);
        return ZonedDateTime.ofInstant(i, tz);
    }

    public static ZonedDateTime toZonedDateTime(Timestamp x, ZoneId tz) {
        Instant i = Instant.ofEpochSecond(x.getTime() / 1000L, x.getNanos());
        return ZonedDateTime.ofInstant(i, tz);
    }

    public static Timestamp toTimestamp(ZonedDateTime zdt, @Nullable ZoneId tz) {
        ZonedDateTime _zdt = tz == null ? zdt : zdt.withZoneSameLocal(tz);
        return Timestamp.from(_zdt.toInstant());
    }
}

