/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.jdbc.statement;

import com.timeplus.client.NativeContext;
import com.timeplus.jdbc.TimeplusConnection;
import com.timeplus.jdbc.statement.AbstractPreparedStatement;
import com.timeplus.misc.DateTimeUtil;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;

public class TimeplusPreparedQueryStatement
extends AbstractPreparedStatement {
    private static String[] splitQueryByQuestionMark(String query) {
        int lastPos = 0;
        ArrayList<String> queryParts = new ArrayList<String>();
        boolean inQuotes = false;
        boolean inBackQuotes = false;
        for (int i = 0; i < query.length(); ++i) {
            char ch = query.charAt(i);
            if (ch == '`') {
                inBackQuotes = !inBackQuotes;
                continue;
            }
            if (ch == '\'') {
                inQuotes = !inQuotes;
                continue;
            }
            if (inBackQuotes || inQuotes || ch != '?') continue;
            queryParts.add(query.substring(lastPos, i));
            lastPos = i + 1;
        }
        queryParts.add(query.substring(lastPos));
        return queryParts.toArray(new String[0]);
    }

    public TimeplusPreparedQueryStatement(TimeplusConnection conn, NativeContext nativeContext, String query) {
        this(conn, nativeContext, TimeplusPreparedQueryStatement.splitQueryByQuestionMark(query));
    }

    private TimeplusPreparedQueryStatement(TimeplusConnection conn, NativeContext nativeContext, String[] parts) {
        super(conn, nativeContext, parts);
    }

    @Override
    public void setObject(int idx, Object x) throws SQLException {
        this.parameters[idx - 1] = this.convertObjectIfNecessary(x);
    }

    @Override
    public boolean execute() throws SQLException {
        return this.execute(this.assembleQueryPartsAndParameters());
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.executeUpdate(this.assembleQueryPartsAndParameters());
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.executeQuery(this.assembleQueryPartsAndParameters());
    }

    public String toString() {
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append(super.toString());
        try {
            queryBuilder.append(": ");
            queryBuilder.append(this.assembleQueryPartsAndParameters());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return queryBuilder.toString();
    }

    private Object convertObjectIfNecessary(Object obj) {
        Object result = obj;
        if (obj instanceof Date) {
            result = ((Date)obj).toLocalDate();
        }
        if (obj instanceof Timestamp) {
            result = DateTimeUtil.toZonedDateTime((Timestamp)obj, this.tz);
        }
        return result;
    }
}

