/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.jdbc;

import com.timeplus.data.IDataType;
import com.timeplus.jdbc.wrapper.SQLStruct;
import com.timeplus.log.Logger;
import com.timeplus.log.LoggerFactory;
import com.timeplus.misc.Validate;
import java.sql.SQLException;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeplusStruct
implements SQLStruct {
    private static final Logger LOG = LoggerFactory.getLogger(TimeplusStruct.class);
    private static final Pattern ATTR_INDEX_REGEX = Pattern.compile("_(\\d+)");
    private final String type;
    private final Object[] attributes;

    public TimeplusStruct(String type, Object[] attributes) {
        this.type = type;
        this.attributes = attributes;
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return this.type;
    }

    @Override
    public Object[] getAttributes() throws SQLException {
        return this.attributes;
    }

    @Override
    public Object[] getAttributes(Map<String, Class<?>> map) throws SQLException {
        int i = 0;
        Object[] res = new Object[map.size()];
        for (String attrName : map.keySet()) {
            Class<?> clazz = map.get(attrName);
            Matcher matcher = ATTR_INDEX_REGEX.matcher(attrName);
            Validate.isTrue(matcher.matches(), "Can't find " + attrName + ".");
            int attrIndex = Integer.parseInt(matcher.group(1)) - 1;
            Validate.isTrue(attrIndex < this.attributes.length, "Can't find " + attrName + ".");
            Validate.isTrue(clazz.isInstance(this.attributes[attrIndex]), "Can't cast " + attrName + " to " + clazz.getName());
            res[i++] = clazz.cast(this.attributes[attrIndex]);
        }
        return res;
    }

    @Override
    public Logger logger() {
        return LOG;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(",", "(", ")");
        for (Object item : this.attributes) {
            joiner.add(String.valueOf(item));
        }
        return joiner.toString();
    }

    public TimeplusStruct mapAttributes(IDataType<?, ?>[] nestedTypes, BiFunction<IDataType<?, ?>, Object, Object> mapFunc) {
        assert (nestedTypes.length == this.attributes.length);
        Object[] mapped = new Object[this.attributes.length];
        for (int i = 0; i < this.attributes.length; ++i) {
            mapped[i] = mapFunc.apply(nestedTypes[i], this.attributes[i]);
        }
        return new TimeplusStruct(this.type, mapped);
    }
}

