/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.jdbc;

import com.timeplus.client.NativeContext;
import com.timeplus.jdbc.TimeplusResultSet;
import com.timeplus.misc.Validate;
import com.timeplus.settings.TimeplusConfig;
import com.timeplus.stream.QueryResult;
import com.timeplus.stream.QueryResultBuilder;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

public class TimeplusResultSetBuilder {
    private final QueryResultBuilder queryResultBuilder;
    private TimeplusConfig cfg;
    private String db = "default";
    private String table = "unknown";

    public static TimeplusResultSetBuilder builder(int columnsNum, NativeContext.ServerContext serverContext) {
        return new TimeplusResultSetBuilder(QueryResultBuilder.builder(columnsNum, serverContext));
    }

    private TimeplusResultSetBuilder(QueryResultBuilder queryResultBuilder) {
        this.queryResultBuilder = queryResultBuilder;
    }

    public TimeplusResultSetBuilder cfg(TimeplusConfig cfg) {
        this.cfg = cfg;
        return this;
    }

    public TimeplusResultSetBuilder db(String db) {
        this.db = db;
        return this;
    }

    public TimeplusResultSetBuilder table(String table) {
        this.table = table;
        return this;
    }

    public TimeplusResultSetBuilder columnNames(String ... names) {
        return this.columnNames(Arrays.asList(names));
    }

    public TimeplusResultSetBuilder columnNames(List<String> names) {
        this.queryResultBuilder.columnNames(names);
        return this;
    }

    public TimeplusResultSetBuilder columnTypes(String ... types) throws SQLException {
        return this.columnTypes(Arrays.asList(types));
    }

    public TimeplusResultSetBuilder columnTypes(List<String> types) throws SQLException {
        this.queryResultBuilder.columnTypes(types);
        return this;
    }

    public TimeplusResultSetBuilder addRow(Object ... row) {
        return this.addRow(Arrays.asList(row));
    }

    public TimeplusResultSetBuilder addRow(List<?> row) {
        this.queryResultBuilder.addRow(row);
        return this;
    }

    public TimeplusResultSet build() throws SQLException {
        Validate.ensure(this.cfg != null);
        QueryResult queryResult = this.queryResultBuilder.build();
        return new TimeplusResultSet(null, this.cfg, this.db, this.table, queryResult.header(), queryResult.data());
    }
}

