/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.jdbc;

import com.timeplus.exception.InvalidValueException;
import com.timeplus.log.Logger;
import com.timeplus.log.LoggerFactory;
import com.timeplus.misc.Validate;
import com.timeplus.settings.SettingKey;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeplusJdbcUrlParser {
    public static final String JDBC_PREFIX = "jdbc:";
    public static final String TIMEPLUS_PREFIX = "timeplus:";
    public static final String JDBC_CLICKHOUSE_PREFIX = "jdbc:timeplus:";
    public static final String HOST_DELIMITER = ",";
    public static final String PORT_DELIMITER = ":";
    public static final Pattern CONNECTION_PATTERN = Pattern.compile("//(?<hosts>([^/?:,\\s]+(:\\d+)?)(,[^/?:,\\s]+(:\\d+)?)*)(?:/(?<database>([a-zA-Z0-9_]+)))?(?:\\?(?<properties>.*))?");
    private static final Logger LOG = LoggerFactory.getLogger(TimeplusJdbcUrlParser.class);

    public static Map<SettingKey, Serializable> parseJdbcUrl(String jdbcUrl) {
        String uri = jdbcUrl.substring(JDBC_CLICKHOUSE_PREFIX.length());
        Matcher matcher = CONNECTION_PATTERN.matcher(uri);
        if (!matcher.matches()) {
            throw new InvalidValueException("Connection is not support");
        }
        HashMap<SettingKey, Serializable> settings = new HashMap<SettingKey, Serializable>();
        String hosts = matcher.group("hosts");
        String database = matcher.group("database");
        String properties = matcher.group("properties");
        if (hosts.contains(HOST_DELIMITER)) {
            settings.put(SettingKey.host, (Serializable)((Object)hosts));
        } else {
            String[] hostAndPort = hosts.split(PORT_DELIMITER, 2);
            settings.put(SettingKey.host, (Serializable)((Object)hostAndPort[0]));
            if (hostAndPort.length == 2) {
                if (Integer.parseInt(hostAndPort[1]) == 8123) {
                    LOG.warn("8123 is default HTTP port, you may connect with error protocol!", new Object[0]);
                }
                settings.put(SettingKey.port, Integer.valueOf(Integer.parseInt(hostAndPort[1])));
            }
        }
        settings.put(SettingKey.database, (Serializable)((Object)database));
        settings.putAll(TimeplusJdbcUrlParser.extractQueryParameters(properties));
        return settings;
    }

    public static Map<SettingKey, Serializable> parseProperties(Properties properties) {
        HashMap<SettingKey, Serializable> settings = new HashMap<SettingKey, Serializable>();
        for (String name : properties.stringPropertyNames()) {
            String value = properties.getProperty(name);
            TimeplusJdbcUrlParser.parseSetting(settings, name, value);
        }
        return settings;
    }

    public static Map<SettingKey, Serializable> extractQueryParameters(String queryParameters) {
        HashMap<SettingKey, Serializable> parameters = new HashMap<SettingKey, Serializable>();
        StringTokenizer tokenizer = new StringTokenizer(queryParameters == null ? "" : queryParameters, "&");
        while (tokenizer.hasMoreTokens()) {
            String[] queryParameter = tokenizer.nextToken().split("=", 2);
            Validate.ensure(queryParameter.length == 2, "ClickHouse JDBC URL Parameter '" + queryParameters + "' Error, Expected '='.");
            String name = queryParameter[0];
            String value = queryParameter[1];
            TimeplusJdbcUrlParser.parseSetting(parameters, name, value);
        }
        return parameters;
    }

    private static void parseSetting(Map<SettingKey, Serializable> settings, String name, String value) {
        SettingKey settingKey = SettingKey.definedSettingKeys().get(name.toLowerCase(Locale.ROOT));
        if (settingKey != null) {
            settings.put(settingKey, (Serializable)settingKey.type().deserializeURL(value));
        } else {
            LOG.warn("ignore undefined setting: {}={}", name, value);
        }
    }
}

