/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.jdbc;

import com.timeplus.jdbc.TimeplusConnection;
import com.timeplus.settings.SettingKey;
import com.timeplus.settings.TimeplusConfig;
import java.io.Serializable;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class TimeplusDriver
implements Driver {
    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith("jdbc:timeplus:");
    }

    @Override
    public TimeplusConnection connect(String url, Properties properties) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        TimeplusConfig cfg = TimeplusConfig.Builder.builder().withJdbcUrl(url).withProperties(properties).build();
        return this.connect(url, cfg);
    }

    TimeplusConnection connect(String url, TimeplusConfig cfg) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        return TimeplusConnection.createClickHouseConnection(cfg.withJdbcUrl(url));
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties properties) throws SQLException {
        TimeplusConfig cfg = TimeplusConfig.Builder.builder().withJdbcUrl(url).withProperties(properties).build();
        int index = 0;
        DriverPropertyInfo[] driverPropertiesInfo = new DriverPropertyInfo[cfg.settings().size()];
        for (Map.Entry<SettingKey, Serializable> entry : cfg.settings().entrySet()) {
            String value = String.valueOf(entry.getValue());
            DriverPropertyInfo property = new DriverPropertyInfo(entry.getKey().name(), value);
            property.description = entry.getKey().description();
            driverPropertiesInfo[index++] = property;
        }
        return driverPropertiesInfo;
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 1;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static {
        try {
            DriverManager.registerDriver(new TimeplusDriver());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

