/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.jdbc;

import com.timeplus.data.IDataType;
import com.timeplus.jdbc.wrapper.SQLArray;
import com.timeplus.log.Logger;
import com.timeplus.log.LoggerFactory;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.StringJoiner;
import java.util.function.BiFunction;

public class TimeplusArray
implements SQLArray {
    private static final Logger LOG = LoggerFactory.getLogger(TimeplusArray.class);
    private final IDataType<?, ?> elementDataType;
    private final Object[] elements;

    public TimeplusArray(IDataType<?, ?> elementDataType, Object[] elements) {
        this.elementDataType = elementDataType;
        this.elements = elements;
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return this.elementDataType.name();
    }

    @Override
    public int getBaseType() {
        return this.elementDataType.sqlTypeId();
    }

    @Override
    public void free() throws SQLException {
    }

    public Object[] getArray() throws SQLException {
        return this.elements;
    }

    @Override
    public Logger logger() {
        return LOG;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(",", "[", "]");
        for (Object item : this.elements) {
            joiner.add(String.valueOf(item));
        }
        return joiner.toString();
    }

    public TimeplusArray slice(int offset, int length) {
        Object[] result = new Object[length];
        if (length >= 0) {
            System.arraycopy(this.elements, offset, result, 0, length);
        }
        return new TimeplusArray(this.elementDataType, result);
    }

    public TimeplusArray mapElements(BiFunction<IDataType<?, ?>, Object, Object> mapFunc) {
        Object[] mapped = Arrays.stream(this.elements).map(elem -> mapFunc.apply(this.elementDataType, elem)).toArray();
        return new TimeplusArray(this.elementDataType, mapped);
    }
}

