/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.jdbc;

import com.timeplus.exception.InvalidValueException;
import com.timeplus.jdbc.TimeplusConnection;
import com.timeplus.jdbc.TimeplusDriver;
import com.timeplus.jdbc.TimeplusJdbcUrlParser;
import com.timeplus.jdbc.wrapper.SQLWrapper;
import com.timeplus.log.LoggerFactory;
import com.timeplus.misc.StrUtil;
import com.timeplus.misc.Validate;
import com.timeplus.settings.SettingKey;
import com.timeplus.settings.TimeplusConfig;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.sql.DataSource;

public final class BalancedTimeplusDataSource
implements DataSource,
SQLWrapper {
    private static final com.timeplus.log.Logger LOG = LoggerFactory.getLogger(BalancedTimeplusDataSource.class);
    private static final Pattern URL_TEMPLATE = Pattern.compile("jdbc:timeplus://([a-zA-Z0-9_:,.-]+)((/[a-zA-Z0-9_]+)?([?][a-zA-Z0-9_]+[=][a-zA-Z0-9_]+([&][a-zA-Z0-9_]+[=][a-zA-Z0-9_]*)*)?)?");
    private PrintWriter printWriter;
    private int loginTimeoutSeconds = 0;
    private final ThreadLocal<Random> randomThreadLocal = new ThreadLocal();
    private final List<String> allUrls;
    private volatile List<String> enabledUrls;
    private final TimeplusConfig cfg;
    private final TimeplusDriver driver = new TimeplusDriver();

    public BalancedTimeplusDataSource(String url) {
        this(BalancedTimeplusDataSource.splitUrl(url), new Properties());
    }

    public BalancedTimeplusDataSource(String url, Properties properties) {
        this(BalancedTimeplusDataSource.splitUrl(url), properties);
    }

    public BalancedTimeplusDataSource(String url, Map<SettingKey, Serializable> settings) {
        this(BalancedTimeplusDataSource.splitUrl(url), settings);
    }

    private BalancedTimeplusDataSource(List<String> urls, Properties properties) {
        this(urls, TimeplusJdbcUrlParser.parseProperties(properties));
    }

    private BalancedTimeplusDataSource(List<String> urls, Map<SettingKey, Serializable> settings) {
        Validate.ensure(!urls.isEmpty(), "Incorrect ClickHouse jdbc url list. It must be not empty");
        this.cfg = TimeplusConfig.Builder.builder().withJdbcUrl(urls.get(0)).withSettings(settings).host("undefined").port(0).build();
        ArrayList<String> allUrls = new ArrayList<String>(urls.size());
        for (String url : urls) {
            try {
                if (this.driver.acceptsURL(url)) {
                    allUrls.add(url);
                    continue;
                }
                LOG.warn("that url is has not correct format: {}", url);
            }
            catch (Exception e) {
                throw new InvalidValueException("error while checking url: " + url, (Throwable)e);
            }
        }
        Validate.ensure(!allUrls.isEmpty(), "there are no correct urls");
        this.allUrls = Collections.unmodifiableList(allUrls);
        this.enabledUrls = this.allUrls;
    }

    static List<String> splitUrl(String url) {
        Matcher m = URL_TEMPLATE.matcher(url);
        Validate.ensure(m.matches(), "Incorrect url: " + url);
        String database = StrUtil.getOrDefault(m.group(2), "");
        String[] hosts = m.group(1).split(",");
        return Arrays.stream(hosts).map(host -> "jdbc:timeplus://" + host + database).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean ping(String url) {
        try (TimeplusConnection connection = this.driver.connect(url, this.cfg);){
            boolean bl = connection.ping(Duration.ofSeconds(1L));
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    synchronized int actualize() {
        ArrayList<String> enabledUrls = new ArrayList<String>(this.allUrls.size());
        for (String url : this.allUrls) {
            LOG.debug("Pinging disabled url: {}", url);
            if (this.ping(url)) {
                LOG.debug("Url is alive now: {}", url);
                enabledUrls.add(url);
                continue;
            }
            LOG.warn("Url is dead now: {}", url);
        }
        this.enabledUrls = Collections.unmodifiableList(enabledUrls);
        return enabledUrls.size();
    }

    private String getAnyUrl() throws SQLException {
        List<String> localEnabledUrls = this.enabledUrls;
        if (localEnabledUrls.isEmpty()) {
            throw new SQLException("Unable to get connection: there are no enabled urls");
        }
        Random random = this.randomThreadLocal.get();
        if (random == null) {
            this.randomThreadLocal.set(new Random());
            random = this.randomThreadLocal.get();
        }
        int index = random.nextInt(localEnabledUrls.size());
        return localEnabledUrls.get(index);
    }

    @Override
    public TimeplusConnection getConnection() throws SQLException {
        return this.driver.connect(this.getAnyUrl(), this.cfg);
    }

    @Override
    public TimeplusConnection getConnection(String user, String password) throws SQLException {
        return this.driver.connect(this.getAnyUrl(), this.cfg.withCredentials(user, password));
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.printWriter;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.printWriter = printWriter;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeoutSeconds = seconds;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeoutSeconds;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    public List<String> getAllClickhouseUrls() {
        return this.allUrls;
    }

    public List<String> getEnabledClickHouseUrls() {
        return this.enabledUrls;
    }

    public List<String> getDisabledUrls() {
        List<String> enabledUrls = this.enabledUrls;
        if (!this.hasDisabledUrls()) {
            return Collections.emptyList();
        }
        ArrayList<String> disabledUrls = new ArrayList<String>(this.allUrls);
        disabledUrls.removeAll(enabledUrls);
        return disabledUrls;
    }

    public boolean hasDisabledUrls() {
        return this.allUrls.size() != this.enabledUrls.size();
    }

    public TimeplusConfig getCfg() {
        return this.cfg;
    }
}

