/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.data.type.complex;

import com.timeplus.data.DataTypeFactory;
import com.timeplus.data.IDataType;
import com.timeplus.data.type.complex.DataTypeCreator;
import com.timeplus.jdbc.TimeplusStruct;
import com.timeplus.misc.SQLLexer;
import com.timeplus.misc.Validate;
import com.timeplus.serde.BinaryDeserializer;
import com.timeplus.serde.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.ArrayList;

public class DataTypeTuple
implements IDataType<TimeplusStruct, Struct> {
    public static DataTypeCreator<TimeplusStruct, Struct> creator = (lexer, serverContext) -> {
        char delimiter;
        Validate.isTrue(lexer.character() == '(');
        ArrayList nestedDataTypes = new ArrayList();
        do {
            nestedDataTypes.add(DataTypeFactory.get(lexer, serverContext));
            delimiter = lexer.character();
            Validate.isTrue(delimiter == ',' || delimiter == ')');
        } while (delimiter != ')');
        StringBuilder builder = new StringBuilder("tuple(");
        for (int i = 0; i < nestedDataTypes.size(); ++i) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append(((IDataType)nestedDataTypes.get(i)).name());
        }
        return new DataTypeTuple(builder.append(")").toString(), nestedDataTypes.toArray(new IDataType[0]));
    };
    private final String name;
    private final IDataType<?, ?>[] nestedTypes;

    public DataTypeTuple(String name, IDataType<?, ?>[] nestedTypes) {
        this.name = name;
        this.nestedTypes = nestedTypes;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int sqlTypeId() {
        return 2002;
    }

    @Override
    public TimeplusStruct defaultValue() {
        Object[] attrs = new Object[this.getNestedTypes().length];
        for (int i = 0; i < this.getNestedTypes().length; ++i) {
            attrs[i] = this.getNestedTypes()[i].defaultValue();
        }
        return new TimeplusStruct("tuple", attrs);
    }

    @Override
    public Class<TimeplusStruct> javaType() {
        return TimeplusStruct.class;
    }

    @Override
    public Class<Struct> jdbcJavaType() {
        return Struct.class;
    }

    @Override
    public int getPrecision() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public void serializeBinary(TimeplusStruct data, BinarySerializer serializer) throws SQLException, IOException {
        for (int i = 0; i < this.getNestedTypes().length; ++i) {
            this.getNestedTypes()[i].serializeBinary(data.getAttributes()[i], serializer);
        }
    }

    public void serializeBinaryBulk(TimeplusStruct[] data, BinarySerializer serializer) throws SQLException, IOException {
        for (int i = 0; i < this.getNestedTypes().length; ++i) {
            Object[] elemsData = new Object[data.length];
            for (int row = 0; row < data.length; ++row) {
                elemsData[row] = data[row].getAttributes()[i];
            }
            this.getNestedTypes()[i].serializeBinaryBulk(elemsData, serializer);
        }
    }

    @Override
    public TimeplusStruct deserializeBinary(BinaryDeserializer deserializer) throws SQLException, IOException {
        Object[] attrs = new Object[this.getNestedTypes().length];
        for (int i = 0; i < this.getNestedTypes().length; ++i) {
            attrs[i] = this.getNestedTypes()[i].deserializeBinary(deserializer);
        }
        return new TimeplusStruct("tuple", attrs);
    }

    public TimeplusStruct[] deserializeBinaryBulk(int rows, BinaryDeserializer deserializer) throws SQLException, IOException {
        Object[][] rowsWithElems = this.getRowsWithElems(rows, deserializer);
        TimeplusStruct[] rowsData = new TimeplusStruct[rows];
        for (int row = 0; row < rows; ++row) {
            Object[] elemsData = new Object[this.getNestedTypes().length];
            for (int elemIndex = 0; elemIndex < this.getNestedTypes().length; ++elemIndex) {
                elemsData[elemIndex] = rowsWithElems[elemIndex][row];
            }
            rowsData[row] = new TimeplusStruct("tuple", elemsData);
        }
        return rowsData;
    }

    private Object[][] getRowsWithElems(int rows, BinaryDeserializer deserializer) throws IOException, SQLException {
        Object[][] rowsWithElems = new Object[this.getNestedTypes().length][];
        for (int index = 0; index < this.getNestedTypes().length; ++index) {
            rowsWithElems[index] = this.getNestedTypes()[index].deserializeBinaryBulk(rows, deserializer);
        }
        return rowsWithElems;
    }

    @Override
    public TimeplusStruct deserializeText(SQLLexer lexer) throws SQLException {
        Validate.isTrue(lexer.character() == '(');
        Object[] tupleData = new Object[this.getNestedTypes().length];
        for (int i = 0; i < this.getNestedTypes().length; ++i) {
            if (i > 0) {
                Validate.isTrue(lexer.character() == ',');
            }
            tupleData[i] = this.getNestedTypes()[i].deserializeText(lexer);
        }
        Validate.isTrue(lexer.character() == ')');
        return new TimeplusStruct("tuple", tupleData);
    }

    public IDataType[] getNestedTypes() {
        return this.nestedTypes;
    }

    @Override
    public void deserializeBinaryPrefix(int rows, BinaryDeserializer deserializer) throws SQLException, IOException {
        for (int i = 0; i < this.getNestedTypes().length; ++i) {
            this.getNestedTypes()[i].deserializeBinaryPrefix(rows, deserializer);
        }
    }

    @Override
    public void deserializeBinarySuffix(int rows, BinaryDeserializer deserializer) throws SQLException, IOException {
        for (int i = 0; i < this.getNestedTypes().length; ++i) {
            this.getNestedTypes()[i].deserializeBinarySuffix(rows, deserializer);
        }
    }
}

