/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.data.type.complex;

import com.timeplus.data.DataTypeFactory;
import com.timeplus.data.IDataType;
import com.timeplus.data.type.complex.DataTypeCreator;
import com.timeplus.misc.SQLLexer;
import com.timeplus.misc.Validate;
import com.timeplus.serde.BinaryDeserializer;
import com.timeplus.serde.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;

public class DataTypeNullable
implements IDataType {
    public static DataTypeCreator creator = (lexer, serverContext) -> {
        Validate.isTrue(lexer.character() == '(');
        IDataType<?, ?> nestedType = DataTypeFactory.get(lexer, serverContext);
        Validate.isTrue(lexer.character() == ')');
        return new DataTypeNullable("nullable(" + nestedType.name() + ")", nestedType, DataTypeFactory.get("uint8", serverContext));
    };
    private static final Short IS_NULL = 1;
    private static final Short NON_NULL = 0;
    private final String name;
    private final IDataType nestedDataType;
    private final IDataType nullMapDataType;

    public IDataType getNestedDataType() {
        return this.nestedDataType;
    }

    public DataTypeNullable(String name, IDataType nestedDataType, IDataType nullMapIDataType) {
        this.name = name;
        this.nestedDataType = nestedDataType;
        this.nullMapDataType = nullMapIDataType;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int sqlTypeId() {
        return this.nestedDataType.sqlTypeId();
    }

    public Object defaultValue() {
        return this.nestedDataType.defaultValue();
    }

    public Class javaType() {
        return this.nestedDataType.javaType();
    }

    public Class jdbcJavaType() {
        return this.nestedDataType.jdbcJavaType();
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public int getPrecision() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    public Object deserializeText(SQLLexer lexer) throws SQLException {
        if (lexer.isCharacter('n') || lexer.isCharacter('N')) {
            Validate.isTrue(Character.toLowerCase(lexer.character()) == 'n');
            Validate.isTrue(Character.toLowerCase(lexer.character()) == 'u');
            Validate.isTrue(Character.toLowerCase(lexer.character()) == 'l');
            Validate.isTrue(Character.toLowerCase(lexer.character()) == 'l');
            return null;
        }
        return this.nestedDataType.deserializeText(lexer);
    }

    public void serializeBinary(Object data, BinarySerializer serializer) throws SQLException, IOException {
        if (data == null) {
            data = this.nestedDataType.defaultValue();
            this.nullMapDataType.serializeBinary(IS_NULL, serializer);
        }
        this.nestedDataType.serializeBinary(data, serializer);
    }

    public void serializeBinaryBulk(Object[] data, BinarySerializer serializer) throws SQLException, IOException {
        Short[] isNull = new Short[data.length];
        for (int i = 0; i < data.length; ++i) {
            isNull[i] = data[i] == null ? IS_NULL : NON_NULL;
            data[i] = data[i] == null ? this.nestedDataType.defaultValue() : data[i];
        }
        this.nullMapDataType.serializeBinaryBulk(isNull, serializer);
        this.nestedDataType.serializeBinaryBulk(data, serializer);
    }

    public Object deserializeBinary(BinaryDeserializer deserializer) throws SQLException, IOException {
        boolean isNull;
        boolean bl = isNull = deserializer.readByte() == 1;
        if (isNull) {
            return null;
        }
        return this.nestedDataType.deserializeBinary(deserializer);
    }

    @Override
    public Object[] deserializeBinaryBulk(int rows, BinaryDeserializer deserializer) throws SQLException, IOException {
        Object[] nullMap = this.nullMapDataType.deserializeBinaryBulk(rows, deserializer);
        Object[] data = this.nestedDataType.deserializeBinaryBulk(rows, deserializer);
        for (int i = 0; i < nullMap.length; ++i) {
            if (!IS_NULL.equals(nullMap[i])) continue;
            data[i] = null;
        }
        return data;
    }

    @Override
    public boolean isSigned() {
        return this.nestedDataType.isSigned();
    }
}

