/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.data.type.complex;

import com.timeplus.data.DataTypeFactory;
import com.timeplus.data.IDataType;
import com.timeplus.data.IndexType;
import com.timeplus.data.type.BaseDataTypeInt;
import com.timeplus.data.type.DataTypeUInt16;
import com.timeplus.data.type.DataTypeUInt32;
import com.timeplus.data.type.DataTypeUInt64;
import com.timeplus.data.type.DataTypeUInt8;
import com.timeplus.data.type.complex.DataTypeCreator;
import com.timeplus.data.type.complex.DataTypeNullable;
import com.timeplus.misc.SQLLexer;
import com.timeplus.misc.Validate;
import com.timeplus.serde.BinaryDeserializer;
import com.timeplus.serde.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;

public class DataTypeLowCardinality
implements IDataType<Object, Object> {
    public static DataTypeCreator<Object, Object> creator = (lexer, serverContext) -> {
        Validate.isTrue(lexer.character() == '(');
        IDataType<?, ?> nestedType = DataTypeFactory.get(lexer, serverContext);
        Validate.isTrue(lexer.character() == ')');
        return new DataTypeLowCardinality("low_cardinality(" + nestedType.name() + ")", nestedType);
    };
    private final String name;
    private final IDataType<?, ?> nestedDataType;
    private final Long version = 1L;
    private final Long IndexTypeMask = 255L;
    private boolean nested_is_nullable;

    public DataTypeLowCardinality(String name, IDataType<?, ?> nestedDataType) {
        this.name = name;
        this.nestedDataType = nestedDataType;
        if (nestedDataType.nullable()) {
            this.nested_is_nullable = true;
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int sqlTypeId() {
        return this.nestedDataType.sqlTypeId();
    }

    @Override
    public Object defaultValue() {
        return this.nestedDataType.defaultValue();
    }

    @Override
    public Class javaType() {
        return this.nestedDataType.javaType();
    }

    @Override
    public Class jdbcJavaType() {
        return this.nestedDataType.jdbcJavaType();
    }

    @Override
    public boolean nullable() {
        return this.nestedDataType.nullable();
    }

    @Override
    public int getPrecision() {
        return this.nestedDataType.getPrecision();
    }

    @Override
    public int getScale() {
        return this.nestedDataType.getScale();
    }

    @Override
    public Object deserializeText(SQLLexer lexer) throws SQLException {
        return this.nestedDataType.deserializeText(lexer);
    }

    @Override
    public void serializeBinary(Object data, BinarySerializer serializer) throws SQLException, IOException {
        this.getNestedTypes().serializeBinary(data, serializer);
    }

    @Override
    public void serializeBinaryBulk(Object[] data, BinarySerializer serializer) throws SQLException, IOException {
        this.getNestedTypes().serializeBinaryBulk(data, serializer);
    }

    @Override
    public Object deserializeBinary(BinaryDeserializer deserializer) throws SQLException, IOException {
        return this.getNestedTypes().deserializeBinary(deserializer);
    }

    @Override
    public Object[] deserializeBinaryBulk(int rows, BinaryDeserializer deserializer) throws SQLException, IOException {
        IDataType inner_type;
        if (rows == 0) {
            Object[] data = this.getNestedTypes().deserializeBinaryBulk(rows, deserializer);
            return data;
        }
        Long index_type = deserializer.readLong() & this.IndexTypeMask;
        Long key_nums = deserializer.readLong();
        Object[] dictionary = new Object[key_nums.intValue()];
        if (this.nested_is_nullable) {
            DataTypeNullable type = (DataTypeNullable)this.getNestedTypes();
            inner_type = type.getNestedDataType();
        } else {
            inner_type = this.getNestedTypes();
        }
        dictionary = inner_type.deserializeBinaryBulk(key_nums.intValue(), deserializer);
        dictionary[0] = null;
        Long row_nums = deserializer.readLong();
        if (row_nums != (long)rows) {
            throw new SQLException("read unexpected rows in low_cardinality, expected:" + rows + ", actual:" + row_nums);
        }
        BaseDataTypeInt<Short, Short> type = index_type == (long)IndexType.UInt8.getValue() ? new DataTypeUInt8() : (index_type == (long)IndexType.UInt16.getValue() ? new DataTypeUInt16() : (index_type == (long)IndexType.UInt32.getValue() ? new DataTypeUInt32() : new DataTypeUInt64()));
        Object[] index_data = type.deserializeBinaryBulk(rows, deserializer);
        Object[] data = new Object[rows];
        if (type instanceof DataTypeUInt8) {
            for (int i = 0; i < rows; ++i) {
                data[i] = dictionary[(Short)index_data[i]];
            }
        } else {
            for (int i = 0; i < rows; ++i) {
                data[i] = dictionary[(Integer)index_data[i]];
            }
        }
        return data;
    }

    @Override
    public boolean isSigned() {
        return this.nestedDataType.isSigned();
    }

    public IDataType getNestedTypes() {
        return this.nestedDataType;
    }

    @Override
    public void deserializeBinaryPrefix(int rows, BinaryDeserializer deserializer) throws SQLException, IOException {
        Long version;
        if (rows != 0 && (version = Long.valueOf(deserializer.readLong())) != this.version) {
            throw new SQLException("version error in type low_cardinality");
        }
    }
}

