/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.data.type.complex;

import com.timeplus.data.IDataType;
import com.timeplus.data.type.complex.DataTypeCreator;
import com.timeplus.misc.SQLLexer;
import com.timeplus.misc.Validate;
import com.timeplus.serde.BinaryDeserializer;
import com.timeplus.serde.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;

public class DataTypeEnum16
implements IDataType<String, String> {
    public static DataTypeCreator<String, String> creator = (lexer, serverContext) -> {
        Validate.isTrue(lexer.character() == '(');
        ArrayList<Short> enumValues = new ArrayList<Short>();
        ArrayList<String> enumNames = new ArrayList<String>();
        for (int i = 0; i < 65536; ++i) {
            enumNames.add(lexer.stringLiteral());
            Validate.isTrue(lexer.character() == '=');
            enumValues.add(lexer.numberLiteral().shortValue());
            char character = lexer.character();
            Validate.isTrue(character == ',' || character == ')');
            if (character != ')') continue;
            StringBuilder builder = new StringBuilder("enum16(");
            for (int index = 0; index < enumNames.size(); ++index) {
                if (index > 0) {
                    builder.append(",");
                }
                builder.append("'").append((String)enumNames.get(index)).append("'").append(" = ").append(enumValues.get(index));
            }
            builder.append(")");
            return new DataTypeEnum16(builder.toString(), enumNames.toArray(new String[0]), enumValues.toArray(new Short[0]));
        }
        throw new SQLException("DataType Enum16 size must be less than 65535");
    };
    private final String name;
    private final Short[] values;
    private final String[] names;

    public DataTypeEnum16(String name, String[] names, Short[] values) {
        this.name = name;
        this.names = names;
        this.values = values;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int sqlTypeId() {
        return 12;
    }

    @Override
    public String defaultValue() {
        return this.names[0];
    }

    @Override
    public Class<String> javaType() {
        return String.class;
    }

    @Override
    public int getPrecision() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public String deserializeText(SQLLexer lexer) throws SQLException {
        return lexer.stringLiteral();
    }

    @Override
    public void serializeBinary(String data, BinarySerializer serializer) throws SQLException, IOException {
        for (int i = 0; i < this.names.length; ++i) {
            if (!data.equals(this.names[i])) continue;
            serializer.writeShort(this.values[i]);
            return;
        }
        StringBuilder message = new StringBuilder("Expected ");
        for (int i = 0; i < this.names.length; ++i) {
            if (i > 0) {
                message.append(" OR ");
            }
            message.append(this.names[i]);
        }
        message.append(", but was ").append(data);
        throw new SQLException(message.toString());
    }

    @Override
    public String deserializeBinary(BinaryDeserializer deserializer) throws SQLException, IOException {
        short value = deserializer.readShort();
        for (int i = 0; i < this.values.length; ++i) {
            if (!this.values[i].equals(value)) continue;
            return this.names[i];
        }
        throw new SQLException("");
    }
}

