/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.data.type.complex;

import com.timeplus.data.DataTypeFactory;
import com.timeplus.data.IDataType;
import com.timeplus.data.type.DataTypeInt64;
import com.timeplus.data.type.complex.DataTypeCreator;
import com.timeplus.jdbc.TimeplusArray;
import com.timeplus.misc.SQLLexer;
import com.timeplus.misc.Validate;
import com.timeplus.serde.BinaryDeserializer;
import com.timeplus.serde.BinarySerializer;
import java.io.IOException;
import java.sql.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;

public class DataTypeArray
implements IDataType<TimeplusArray, Array> {
    public static DataTypeCreator<TimeplusArray, Array> creator = (lexer, serverContext) -> {
        Validate.isTrue(lexer.character() == '(');
        IDataType<?, ?> arrayNestedType = DataTypeFactory.get(lexer, serverContext);
        Validate.isTrue(lexer.character() == ')');
        return new DataTypeArray("array(" + arrayNestedType.name() + ")", arrayNestedType, (DataTypeInt64)DataTypeFactory.get("int64", serverContext));
    };
    private final String name;
    private final TimeplusArray defaultValue;
    private final IDataType<?, ?> elemDataType;
    private final DataTypeInt64 offsetIDataType;

    public DataTypeArray(String name, IDataType<?, ?> elemDataType, DataTypeInt64 offsetIDataType) throws SQLException {
        this.name = name;
        this.elemDataType = elemDataType;
        this.offsetIDataType = offsetIDataType;
        this.defaultValue = new TimeplusArray(elemDataType, new Object[]{elemDataType.defaultValue()});
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int sqlTypeId() {
        return 2003;
    }

    @Override
    public TimeplusArray defaultValue() {
        return this.defaultValue;
    }

    @Override
    public Class<TimeplusArray> javaType() {
        return TimeplusArray.class;
    }

    @Override
    public Class<Array> jdbcJavaType() {
        return Array.class;
    }

    @Override
    public int getPrecision() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public TimeplusArray deserializeText(SQLLexer lexer) throws SQLException {
        Validate.isTrue(lexer.character() == '[');
        ArrayList arrayData = new ArrayList();
        while (true) {
            if (lexer.isCharacter(']')) break;
            if (lexer.isCharacter(',')) {
                lexer.character();
            }
            arrayData.add(this.elemDataType.deserializeText(lexer));
        }
        lexer.character();
        return new TimeplusArray(this.elemDataType, arrayData.toArray());
    }

    @Override
    public void serializeBinary(TimeplusArray data, BinarySerializer serializer) throws SQLException, IOException {
        for (Object f : data.getArray()) {
            this.getElemDataType().serializeBinary(f, serializer);
        }
    }

    public void serializeBinaryBulk(TimeplusArray[] data, BinarySerializer serializer) throws SQLException, IOException {
        this.offsetIDataType.serializeBinary(Long.valueOf(data.length), serializer);
        this.getElemDataType().serializeBinaryBulk(data, serializer);
    }

    @Override
    public TimeplusArray deserializeBinary(BinaryDeserializer deserializer) throws SQLException, IOException {
        Long offset = this.offsetIDataType.deserializeBinary(deserializer);
        Object[] data = this.getElemDataType().deserializeBinaryBulk(offset.intValue(), deserializer);
        return new TimeplusArray(this.elemDataType, data);
    }

    public TimeplusArray[] deserializeBinaryBulk(int rows, BinaryDeserializer deserializer) throws IOException, SQLException {
        TimeplusArray[] arrays = new TimeplusArray[rows];
        if (rows == 0) {
            return arrays;
        }
        int[] offsets = Arrays.stream(this.offsetIDataType.deserializeBinaryBulk(rows, deserializer)).mapToInt(value -> ((Long)value).intValue()).toArray();
        TimeplusArray res = new TimeplusArray(this.elemDataType, this.elemDataType.deserializeBinaryBulk(offsets[rows - 1], deserializer));
        int lastOffset = 0;
        for (int row = 0; row < rows; ++row) {
            int offset = offsets[row];
            arrays[row] = res.slice(lastOffset, offset - lastOffset);
            lastOffset = offset;
        }
        return arrays;
    }

    public IDataType getElemDataType() {
        return this.elemDataType;
    }

    @Override
    public void deserializeBinaryPrefix(int rows, BinaryDeserializer deserializer) throws SQLException, IOException {
        this.getElemDataType().deserializeBinaryPrefix(rows, deserializer);
    }

    @Override
    public void deserializeBinarySuffix(int rows, BinaryDeserializer deserializer) throws SQLException, IOException {
        this.getElemDataType().deserializeBinarySuffix(rows, deserializer);
    }
}

