/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.data.type;

import com.timeplus.data.IDataType;
import com.timeplus.misc.SQLLexer;
import com.timeplus.serde.BinaryDeserializer;
import com.timeplus.serde.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;
import java.util.UUID;

public class DataTypeUUID
implements IDataType<UUID, String> {
    @Override
    public String name() {
        return "uuid";
    }

    @Override
    public int sqlTypeId() {
        return 12;
    }

    @Override
    public UUID defaultValue() {
        return UUID.fromString("00000000-0000-0000-0000-000000000000");
    }

    @Override
    public Class<UUID> javaType() {
        return UUID.class;
    }

    @Override
    public Class<String> jdbcJavaType() {
        return String.class;
    }

    @Override
    public int getPrecision() {
        return 36;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public UUID deserializeText(SQLLexer lexer) throws SQLException {
        return UUID.fromString(lexer.stringLiteral());
    }

    @Override
    public void serializeBinary(UUID data, BinarySerializer serializer) throws SQLException, IOException {
        serializer.writeLong(data.getMostSignificantBits());
        serializer.writeLong(data.getLeastSignificantBits());
    }

    @Override
    public UUID deserializeBinary(BinaryDeserializer deserializer) throws SQLException, IOException {
        return new UUID(deserializer.readLong(), deserializer.readLong());
    }
}

