/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.data.type;

import com.timeplus.data.type.BaseDataTypeInt64;
import com.timeplus.misc.BytesHelper;
import com.timeplus.misc.SQLLexer;
import com.timeplus.serde.BinaryDeserializer;
import com.timeplus.serde.BinarySerializer;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.SQLException;

public class DataTypeUInt64
implements BaseDataTypeInt64<BigInteger, BigInteger>,
BytesHelper {
    @Override
    public String name() {
        return "uint64";
    }

    @Override
    public BigInteger defaultValue() {
        return BigInteger.ZERO;
    }

    @Override
    public Class<BigInteger> javaType() {
        return BigInteger.class;
    }

    @Override
    public int getPrecision() {
        return 19;
    }

    @Override
    public void serializeBinary(BigInteger data, BinarySerializer serializer) throws SQLException, IOException {
        serializer.writeLong(data.longValue());
    }

    @Override
    public BigInteger deserializeBinary(BinaryDeserializer deserializer) throws SQLException, IOException {
        long l = deserializer.readLong();
        return new BigInteger(1, this.getBytes(l));
    }

    @Override
    public String[] getAliases() {
        return new String[0];
    }

    @Override
    public BigInteger deserializeText(SQLLexer lexer) throws SQLException {
        return BigInteger.valueOf(lexer.numberLiteral().longValue());
    }
}

