/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.data.type;

import com.timeplus.data.type.BaseDataTypeInt64;
import com.timeplus.misc.BytesHelper;
import com.timeplus.misc.SQLLexer;
import com.timeplus.serde.BinaryDeserializer;
import com.timeplus.serde.BinarySerializer;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.SQLException;

public class DataTypeUInt256
implements BaseDataTypeInt64<BigInteger, BigInteger>,
BytesHelper {
    @Override
    public String name() {
        return "uint256";
    }

    @Override
    public BigInteger defaultValue() {
        return BigInteger.ZERO;
    }

    @Override
    public Class<BigInteger> javaType() {
        return BigInteger.class;
    }

    @Override
    public int getPrecision() {
        return 78;
    }

    @Override
    public void serializeBinary(BigInteger data, BinarySerializer serializer) throws SQLException, IOException {
        serializer.writeBigInteger(data, 32);
    }

    @Override
    public BigInteger deserializeBinary(BinaryDeserializer deserializer) throws SQLException, IOException {
        byte[] bytes = deserializer.readBytes(32);
        return new BigInteger(1, deserializer.reversesBytes(bytes));
    }

    @Override
    public String[] getAliases() {
        return new String[0];
    }

    @Override
    public BigInteger deserializeText(SQLLexer lexer) throws SQLException {
        String Uinteger256 = lexer.stringLiteral();
        return new BigInteger(Uinteger256, 10);
    }
}

