/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.data.type;

import com.timeplus.data.type.BaseDataTypeInt64;
import com.timeplus.misc.SQLLexer;
import com.timeplus.serde.BinaryDeserializer;
import com.timeplus.serde.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;

public class DataTypeInt64
implements BaseDataTypeInt64<Long, Long> {
    @Override
    public String name() {
        return "int64";
    }

    @Override
    public Long defaultValue() {
        return 0L;
    }

    @Override
    public Class<Long> javaType() {
        return Long.class;
    }

    @Override
    public int getPrecision() {
        return 20;
    }

    @Override
    public void serializeBinary(Long data, BinarySerializer serializer) throws SQLException, IOException {
        serializer.writeLong(data);
    }

    @Override
    public Long deserializeBinary(BinaryDeserializer deserializer) throws SQLException, IOException {
        return deserializer.readLong();
    }

    @Override
    public String[] getAliases() {
        return new String[]{"bigint"};
    }

    @Override
    public Long deserializeText(SQLLexer lexer) throws SQLException {
        return lexer.numberLiteral().longValue();
    }

    @Override
    public boolean isSigned() {
        return true;
    }
}

