/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.data.type;

import com.timeplus.data.type.BaseDataTypeInt32;
import com.timeplus.misc.SQLLexer;
import com.timeplus.serde.BinaryDeserializer;
import com.timeplus.serde.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;

public class DataTypeInt32
implements BaseDataTypeInt32<Integer, Integer> {
    @Override
    public String name() {
        return "int32";
    }

    @Override
    public Integer defaultValue() {
        return 0;
    }

    @Override
    public Class<Integer> javaType() {
        return Integer.class;
    }

    @Override
    public int getPrecision() {
        return 11;
    }

    @Override
    public void serializeBinary(Integer data, BinarySerializer serializer) throws SQLException, IOException {
        serializer.writeInt(data);
    }

    @Override
    public Integer deserializeBinary(BinaryDeserializer deserializer) throws SQLException, IOException {
        return deserializer.readInt();
    }

    @Override
    public String[] getAliases() {
        return new String[]{"int", "integer"};
    }

    @Override
    public Integer deserializeText(SQLLexer lexer) throws SQLException {
        return lexer.numberLiteral().intValue();
    }

    @Override
    public boolean isSigned() {
        return true;
    }
}

