/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.data.type;

import com.timeplus.data.IDataType;
import com.timeplus.misc.SQLLexer;
import com.timeplus.serde.BinaryDeserializer;
import com.timeplus.serde.BinarySerializer;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.SQLException;

public class DataTypeInt256
implements IDataType<BigInteger, BigInteger> {
    @Override
    public String name() {
        return "int256";
    }

    @Override
    public int sqlTypeId() {
        return -5;
    }

    @Override
    public BigInteger defaultValue() {
        return BigInteger.ZERO;
    }

    @Override
    public Class<BigInteger> javaType() {
        return BigInteger.class;
    }

    @Override
    public int getPrecision() {
        return 78;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public void serializeBinary(BigInteger data, BinarySerializer serializer) throws SQLException, IOException {
        serializer.writeBigInteger(data, 32);
    }

    @Override
    public BigInteger deserializeBinary(BinaryDeserializer deserializer) throws SQLException, IOException {
        byte[] bytes = deserializer.readBytes(32);
        return new BigInteger(deserializer.reversesBytes(bytes));
    }

    @Override
    public BigInteger deserializeText(SQLLexer lexer) throws SQLException {
        String Integer256 = lexer.stringLiteral();
        return new BigInteger(Integer256, 10);
    }
}

