/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.data.type;

import com.timeplus.data.IDataType;
import com.timeplus.misc.SQLLexer;
import com.timeplus.serde.BinaryDeserializer;
import com.timeplus.serde.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;

public class DataTypeFloat64
implements IDataType<Double, Double> {
    @Override
    public String name() {
        return "float64";
    }

    @Override
    public int sqlTypeId() {
        return 8;
    }

    @Override
    public Double defaultValue() {
        return 0.0;
    }

    @Override
    public Class<Double> javaType() {
        return Double.class;
    }

    @Override
    public int getPrecision() {
        return 17;
    }

    @Override
    public int getScale() {
        return 17;
    }

    @Override
    public void serializeBinary(Double data, BinarySerializer serializer) throws SQLException, IOException {
        serializer.writeDouble(data);
    }

    @Override
    public Double deserializeBinary(BinaryDeserializer deserializer) throws SQLException, IOException {
        return deserializer.readDouble();
    }

    @Override
    public String[] getAliases() {
        return new String[]{"double"};
    }

    @Override
    public Double deserializeText(SQLLexer lexer) throws SQLException {
        return lexer.numberLiteral().doubleValue();
    }

    @Override
    public boolean isSigned() {
        return true;
    }
}

