/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.data.type;

import com.timeplus.data.type.BaseDataTypeBool;
import com.timeplus.misc.SQLLexer;
import com.timeplus.serde.BinaryDeserializer;
import com.timeplus.serde.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;

public class DataTypeBool
implements BaseDataTypeBool<Byte, Byte> {
    @Override
    public String name() {
        return "bool";
    }

    @Override
    public Byte defaultValue() {
        return (byte)0;
    }

    @Override
    public Class<Byte> javaType() {
        return Byte.class;
    }

    @Override
    public int getPrecision() {
        return 4;
    }

    @Override
    public void serializeBinary(Byte data, BinarySerializer serializer) throws SQLException, IOException {
        serializer.writeByte(data);
    }

    @Override
    public Byte deserializeBinary(BinaryDeserializer deserializer) throws IOException {
        return deserializer.readByte();
    }

    @Override
    public String[] getAliases() {
        return new String[]{"TINYINT"};
    }

    @Override
    public Byte deserializeText(SQLLexer lexer) throws SQLException {
        return lexer.numberLiteral().byteValue();
    }

    @Override
    public boolean isSigned() {
        return true;
    }
}

