/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.data;

import com.timeplus.client.NativeContext;
import com.timeplus.data.IDataType;
import com.timeplus.data.type.DataTypeBool;
import com.timeplus.data.type.DataTypeDate;
import com.timeplus.data.type.DataTypeDate32;
import com.timeplus.data.type.DataTypeFloat32;
import com.timeplus.data.type.DataTypeFloat64;
import com.timeplus.data.type.DataTypeIPv4;
import com.timeplus.data.type.DataTypeIPv6;
import com.timeplus.data.type.DataTypeInt128;
import com.timeplus.data.type.DataTypeInt16;
import com.timeplus.data.type.DataTypeInt256;
import com.timeplus.data.type.DataTypeInt32;
import com.timeplus.data.type.DataTypeInt64;
import com.timeplus.data.type.DataTypeInt8;
import com.timeplus.data.type.DataTypeUInt128;
import com.timeplus.data.type.DataTypeUInt16;
import com.timeplus.data.type.DataTypeUInt256;
import com.timeplus.data.type.DataTypeUInt32;
import com.timeplus.data.type.DataTypeUInt64;
import com.timeplus.data.type.DataTypeUInt8;
import com.timeplus.data.type.DataTypeUUID;
import com.timeplus.data.type.complex.DataTypeArray;
import com.timeplus.data.type.complex.DataTypeCreator;
import com.timeplus.data.type.complex.DataTypeDateTime;
import com.timeplus.data.type.complex.DataTypeDateTime64;
import com.timeplus.data.type.complex.DataTypeDecimal;
import com.timeplus.data.type.complex.DataTypeEnum16;
import com.timeplus.data.type.complex.DataTypeEnum8;
import com.timeplus.data.type.complex.DataTypeFixedString;
import com.timeplus.data.type.complex.DataTypeLowCardinality;
import com.timeplus.data.type.complex.DataTypeMap;
import com.timeplus.data.type.complex.DataTypeNothing;
import com.timeplus.data.type.complex.DataTypeNullable;
import com.timeplus.data.type.complex.DataTypeString;
import com.timeplus.data.type.complex.DataTypeTuple;
import com.timeplus.misc.LRUCache;
import com.timeplus.misc.SQLLexer;
import com.timeplus.misc.Validate;
import com.timeplus.settings.TimeplusDefines;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DataTypeFactory {
    private static final LRUCache<String, IDataType<?, ?>> DATA_TYPE_CACHE = new LRUCache(TimeplusDefines.DATA_TYPE_CACHE_SIZE);
    private static final Map<String, IDataType<?, ?>> dataTypes = DataTypeFactory.initialDataTypes();

    public static IDataType<?, ?> get(String type, NativeContext.ServerContext serverContext) throws SQLException {
        IDataType<?, ?> dataType = DATA_TYPE_CACHE.get(type);
        if (dataType != null) {
            DATA_TYPE_CACHE.put(type, dataType);
            return dataType;
        }
        SQLLexer lexer = new SQLLexer(0, type);
        dataType = DataTypeFactory.get(lexer, serverContext);
        Validate.isTrue(lexer.eof());
        DATA_TYPE_CACHE.put(type, dataType);
        return dataType;
    }

    public static IDataType<?, ?> get(SQLLexer lexer, NativeContext.ServerContext serverContext) throws SQLException {
        String dataTypeName = String.valueOf(lexer.bareWord());
        if (dataTypeName.equalsIgnoreCase("tuple")) {
            return DataTypeTuple.creator.createDataType(lexer, serverContext);
        }
        if (dataTypeName.equalsIgnoreCase("array")) {
            return DataTypeArray.creator.createDataType(lexer, serverContext);
        }
        if (dataTypeName.equalsIgnoreCase("enum8")) {
            return DataTypeEnum8.creator.createDataType(lexer, serverContext);
        }
        if (dataTypeName.equalsIgnoreCase("enum16")) {
            return DataTypeEnum16.creator.createDataType(lexer, serverContext);
        }
        if (dataTypeName.equalsIgnoreCase("datetime")) {
            return DataTypeDateTime.creator.createDataType(lexer, serverContext);
        }
        if (dataTypeName.equalsIgnoreCase("datetime64")) {
            return DataTypeDateTime64.creator.createDataType(lexer, serverContext);
        }
        if (dataTypeName.equalsIgnoreCase("nullable")) {
            return DataTypeNullable.creator.createDataType(lexer, serverContext);
        }
        if (dataTypeName.equalsIgnoreCase("low_cardinality")) {
            return DataTypeLowCardinality.creator.createDataType(lexer, serverContext);
        }
        if (dataTypeName.equalsIgnoreCase("fixed_string") || dataTypeName.equals("binary")) {
            return DataTypeFixedString.creator.createDataType(lexer, serverContext);
        }
        if (dataTypeName.equalsIgnoreCase("decimal")) {
            return DataTypeDecimal.creator.createDataType(lexer, serverContext);
        }
        if (dataTypeName.equalsIgnoreCase("string")) {
            return DataTypeString.CREATOR.createDataType(lexer, serverContext);
        }
        if (dataTypeName.equalsIgnoreCase("nothing")) {
            return DataTypeNothing.CREATOR.createDataType(lexer, serverContext);
        }
        if (dataTypeName.equalsIgnoreCase("map")) {
            return DataTypeMap.creator.createDataType(lexer, serverContext);
        }
        IDataType<?, ?> dataType = dataTypes.get(dataTypeName.toLowerCase(Locale.ROOT));
        Validate.isTrue(dataType != null, "Unknown data type: " + dataTypeName);
        return dataType;
    }

    private static Map<String, IDataType<?, ?>> initialDataTypes() {
        HashMap creators = new HashMap();
        DataTypeFactory.registerType(creators, new DataTypeIPv4());
        DataTypeFactory.registerType(creators, new DataTypeIPv6());
        DataTypeFactory.registerType(creators, new DataTypeUUID());
        DataTypeFactory.registerType(creators, new DataTypeFloat32());
        DataTypeFactory.registerType(creators, new DataTypeFloat64());
        DataTypeFactory.registerType(creators, new DataTypeBool());
        DataTypeFactory.registerType(creators, new DataTypeInt8());
        DataTypeFactory.registerType(creators, new DataTypeInt16());
        DataTypeFactory.registerType(creators, new DataTypeInt32());
        DataTypeFactory.registerType(creators, new DataTypeInt64());
        DataTypeFactory.registerType(creators, new DataTypeInt128());
        DataTypeFactory.registerType(creators, new DataTypeInt256());
        DataTypeFactory.registerType(creators, new DataTypeUInt8());
        DataTypeFactory.registerType(creators, new DataTypeUInt16());
        DataTypeFactory.registerType(creators, new DataTypeUInt32());
        DataTypeFactory.registerType(creators, new DataTypeUInt64());
        DataTypeFactory.registerType(creators, new DataTypeUInt128());
        DataTypeFactory.registerType(creators, new DataTypeUInt256());
        DataTypeFactory.registerType(creators, new DataTypeDate());
        DataTypeFactory.registerType(creators, new DataTypeDate32());
        return creators;
    }

    private static void registerType(Map<String, IDataType<?, ?>> creators, IDataType<?, ?> type) {
        creators.put(type.name().toLowerCase(Locale.ROOT), type);
        for (String typeName : type.getAliases()) {
            creators.put(typeName.toLowerCase(Locale.ROOT), type);
        }
    }

    private static Map<String, DataTypeCreator<?, ?>> initComplexDataTypes() {
        return new HashMap();
    }

    private static void registerComplexType(Map<String, DataTypeCreator<?, ?>> creators, IDataType<?, ?> type, DataTypeCreator<?, ?> creator) {
        creators.put(type.name().toLowerCase(Locale.ROOT), creator);
        for (String typeName : type.getAliases()) {
            creators.put(typeName.toLowerCase(Locale.ROOT), creator);
        }
    }
}

