/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.data;

import com.timeplus.data.AbstractColumn;
import com.timeplus.data.ColumnFactory;
import com.timeplus.data.ColumnWriterBuffer;
import com.timeplus.data.IColumn;
import com.timeplus.data.IDataType;
import com.timeplus.data.type.complex.DataTypeTuple;
import com.timeplus.jdbc.TimeplusStruct;
import com.timeplus.serde.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;

public class ColumnTuple
extends AbstractColumn {
    private final IColumn[] columnDataArray;

    public ColumnTuple(String name, DataTypeTuple type, Object[] values) {
        super(name, type, values);
        IDataType[] types = type.getNestedTypes();
        this.columnDataArray = new IColumn[types.length];
        for (int i = 0; i < types.length; ++i) {
            this.columnDataArray[i] = ColumnFactory.createColumn(null, types[i], null);
        }
    }

    @Override
    public void write(Object object) throws IOException, SQLException {
        TimeplusStruct tuple = (TimeplusStruct)object;
        for (int i = 0; i < this.columnDataArray.length; ++i) {
            this.columnDataArray[i].write(tuple.getAttributes()[i]);
        }
    }

    @Override
    public void setColumnWriterBuffer(ColumnWriterBuffer buffer) {
        super.setColumnWriterBuffer(buffer);
        for (IColumn nestedColumn : this.columnDataArray) {
            nestedColumn.setColumnWriterBuffer(new ColumnWriterBuffer());
        }
    }

    @Override
    public void clear() {
    }

    @Override
    public void SerializeBulkPrefix(BinarySerializer serializer) throws SQLException, IOException {
        for (IColumn nestedColumn : this.columnDataArray) {
            nestedColumn.SerializeBulkPrefix(serializer);
        }
    }

    @Override
    public void SerializeBulk(BinarySerializer serializer, Boolean now) throws IOException, SQLException {
        for (IColumn nestedColumn : this.columnDataArray) {
            nestedColumn.SerializeBulk(serializer, true);
        }
        if (now.booleanValue()) {
            this.buffer.writeTo(serializer);
        }
    }
}

