/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.data;

import com.timeplus.data.AbstractColumn;
import com.timeplus.data.ColumnFactory;
import com.timeplus.data.ColumnWriterBuffer;
import com.timeplus.data.IColumn;
import com.timeplus.data.type.complex.DataTypeNullable;
import com.timeplus.serde.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class ColumnNullable
extends AbstractColumn {
    private final List<Byte> nullableSign = new ArrayList<Byte>();
    private final IColumn nestedColumn;

    public ColumnNullable(String name, DataTypeNullable type, Object[] values) {
        super(name, type, values);
        this.nestedColumn = ColumnFactory.createColumn(null, type.getNestedDataType(), null);
    }

    @Override
    public void write(@Nullable Object object) throws IOException, SQLException {
        if (object == null) {
            this.nullableSign.add((byte)1);
            this.nestedColumn.write(this.type.defaultValue());
        } else {
            this.nullableSign.add((byte)0);
            this.nestedColumn.write(object);
        }
    }

    @Override
    public void setColumnWriterBuffer(ColumnWriterBuffer buffer) {
        super.setColumnWriterBuffer(buffer);
        this.nestedColumn.setColumnWriterBuffer(buffer);
    }

    @Override
    public void SerializeBulk(BinarySerializer serializer, Boolean now) throws IOException, SQLException {
        for (byte sign : this.nullableSign) {
            serializer.writeByte(sign);
        }
        if (now.booleanValue()) {
            this.buffer.writeTo(serializer);
        }
    }
}

