/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.data;

import com.timeplus.data.AbstractColumn;
import com.timeplus.data.ColumnFactory;
import com.timeplus.data.ColumnWriterBuffer;
import com.timeplus.data.IColumn;
import com.timeplus.data.IDataType;
import com.timeplus.data.type.complex.DataTypeMap;
import com.timeplus.serde.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ColumnMap
extends AbstractColumn {
    private final IColumn[] columnDataArray;
    private final List<Long> offsets = new ArrayList<Long>();

    public ColumnMap(String name, DataTypeMap type, Object[] values) {
        super(name, type, values);
        IDataType[] types = type.getNestedTypes();
        this.columnDataArray = new IColumn[types.length];
        for (int i = 0; i < types.length; ++i) {
            this.columnDataArray[i] = ColumnFactory.createColumn(null, types[i], null);
        }
    }

    @Override
    public void write(Object object) throws IOException, SQLException {
        if (object instanceof Map) {
            Map dataMap = (Map)object;
            this.offsets.add(this.offsets.isEmpty() ? (long)dataMap.size() : this.offsets.get(this.offsets.size() - 1) + (long)dataMap.size());
            for (Object key : dataMap.keySet()) {
                this.columnDataArray[0].write(key);
            }
            for (Object value : dataMap.values()) {
                this.columnDataArray[1].write(value);
            }
        }
    }

    public void flushOffsets(BinarySerializer serializer) throws IOException {
        for (long offsetList : this.offsets) {
            serializer.writeLong(offsetList);
        }
    }

    @Override
    public void setColumnWriterBuffer(ColumnWriterBuffer buffer) {
        super.setColumnWriterBuffer(buffer);
        for (IColumn nestedColumn : this.columnDataArray) {
            nestedColumn.setColumnWriterBuffer(new ColumnWriterBuffer());
        }
    }

    @Override
    public void clear() {
        this.offsets.clear();
        for (IColumn nestedColumn : this.columnDataArray) {
            nestedColumn.clear();
        }
    }

    @Override
    public void SerializeBulkPrefix(BinarySerializer serializer) throws SQLException, IOException {
        for (IColumn nestedColumn : this.columnDataArray) {
            nestedColumn.SerializeBulkPrefix(serializer);
        }
    }

    @Override
    public void SerializeBulk(BinarySerializer serializer, Boolean now) throws IOException, SQLException {
        this.flushOffsets(serializer);
        for (IColumn nestedColumn : this.columnDataArray) {
            nestedColumn.SerializeBulk(serializer, true);
        }
        if (now.booleanValue()) {
            this.buffer.writeTo(serializer);
        }
    }
}

