/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.data;

import com.timeplus.data.AbstractColumn;
import com.timeplus.data.ColumnWriterBuffer;
import com.timeplus.data.IDataType;
import com.timeplus.data.IndexType;
import com.timeplus.data.type.complex.DataTypeLowCardinality;
import com.timeplus.data.type.complex.DataTypeNullable;
import com.timeplus.serde.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ColumnLowCardinality
extends AbstractColumn {
    private final List<Long> indexes = new ArrayList<Long>();
    private final List<Object> dict = new ArrayList<Object>();
    private final Long version = 1L;
    private boolean nested_is_nullable;
    private IDataType nested_type;

    public ColumnLowCardinality(String name, DataTypeLowCardinality type, Object[] values) {
        super(name, type, values);
        this.nested_is_nullable = type.getNestedTypes().nullable();
        if (this.nested_is_nullable) {
            this.nested_type = ((DataTypeNullable)type.getNestedTypes()).getNestedDataType();
            this.dict.add(type.getNestedTypes().defaultValue());
            this.dict.add(type.getNestedTypes().defaultValue());
        } else {
            this.nested_type = type.getNestedTypes();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void write(Object object) throws IOException, SQLException {
        if (object == null) {
            if (!this.nested_is_nullable) throw new SQLException("null object appeared without nullable field");
            this.indexes.add(0L);
            return;
        } else {
            long value = this.dict.lastIndexOf(object);
            if (value != -1L) {
                this.indexes.add(value);
                return;
            } else {
                this.indexes.add(Long.valueOf(this.dict.size()));
                this.dict.add(object);
            }
        }
    }

    @Override
    public void setColumnWriterBuffer(ColumnWriterBuffer buffer) {
        super.setColumnWriterBuffer(buffer);
    }

    @Override
    public void clear() {
    }

    @Override
    public void SerializeBulkPrefix(BinarySerializer serializer) throws IOException, SQLException {
        serializer.writeLong(this.version);
    }

    @Override
    public void SerializeBulk(BinarySerializer serializer, Boolean now) throws IOException, SQLException {
        serializer.writeLong(IndexType.UInt64.getValue() | IndexType.HasAdditionalKeysBit.getValue());
        serializer.writeLong(this.dict.size());
        this.nested_type.serializeBinaryBulk(this.dict.toArray(), serializer);
        serializer.writeLong(this.indexes.size());
        for (int i = 0; i < this.indexes.size(); ++i) {
            serializer.writeLong(this.indexes.get(i));
        }
    }
}

