/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.data;

import com.timeplus.data.AbstractColumn;
import com.timeplus.data.ColumnFactory;
import com.timeplus.data.ColumnWriterBuffer;
import com.timeplus.data.IColumn;
import com.timeplus.data.type.complex.DataTypeArray;
import com.timeplus.jdbc.TimeplusArray;
import com.timeplus.serde.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ColumnArray
extends AbstractColumn {
    private final List<Long> offsets = new ArrayList<Long>();
    private final IColumn nestedColumn;

    public ColumnArray(String name, DataTypeArray type, Object[] values) {
        super(name, type, values);
        this.nestedColumn = ColumnFactory.createColumn(null, type.getElemDataType(), null);
    }

    @Override
    public void write(Object object) throws IOException, SQLException {
        Object[] arr = ((TimeplusArray)object).getArray();
        this.offsets.add(this.offsets.isEmpty() ? (long)arr.length : this.offsets.get(this.offsets.size() - 1) + (long)arr.length);
        for (Object field : arr) {
            this.nestedColumn.write(field);
        }
    }

    public void flushOffsets(BinarySerializer serializer) throws IOException {
        for (long offsetList : this.offsets) {
            serializer.writeLong(offsetList);
        }
    }

    @Override
    public void setColumnWriterBuffer(ColumnWriterBuffer buffer) {
        super.setColumnWriterBuffer(buffer);
        this.nestedColumn.setColumnWriterBuffer(buffer);
    }

    @Override
    public void clear() {
        this.offsets.clear();
        this.nestedColumn.clear();
    }

    @Override
    public void SerializeBulkPrefix(BinarySerializer serializer) throws SQLException, IOException {
        this.nestedColumn.SerializeBulkPrefix(serializer);
    }

    @Override
    public void SerializeBulk(BinarySerializer serializer, Boolean now) throws IOException, SQLException {
        this.flushOffsets(serializer);
        this.nestedColumn.SerializeBulk(serializer, false);
        if (now.booleanValue()) {
            this.buffer.writeTo(serializer);
        }
    }

    @Override
    public void SerializeBulkSuffix(BinarySerializer serializer) throws SQLException, IOException {
        this.nestedColumn.SerializeBulkSuffix(serializer);
    }
}

