/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.data;

import com.timeplus.client.NativeContext;
import com.timeplus.data.BlockInfo;
import com.timeplus.data.ColumnFactory;
import com.timeplus.data.ColumnWriterBuffer;
import com.timeplus.data.ColumnWriterBufferFactory;
import com.timeplus.data.DataTypeFactory;
import com.timeplus.data.IColumn;
import com.timeplus.data.IDataType;
import com.timeplus.misc.Validate;
import com.timeplus.serde.BinaryDeserializer;
import com.timeplus.serde.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class Block {
    private final IColumn[] columns;
    private final BlockInfo settings;
    private final Map<String, Integer> nameAndPositions;
    private final Object[] rowData;
    private final int[] placeholderIndexes;
    private int rowCnt;
    private long readRows = 0L;
    private long readBytes = 0L;

    public static Block readFrom(BinaryDeserializer deserializer, NativeContext.ServerContext serverContext) throws IOException, SQLException {
        BlockInfo info = null;
        if (serverContext.revision() > 0L) {
            info = BlockInfo.readFrom(deserializer);
        }
        int columnCnt = (int)deserializer.readVarInt();
        int rowCnt = (int)deserializer.readVarInt();
        IColumn[] columns = new IColumn[columnCnt];
        for (int i = 0; i < columnCnt; ++i) {
            String name = deserializer.readUTF8StringBinary();
            String type = deserializer.readUTF8StringBinary();
            IDataType<?, ?> dataType = DataTypeFactory.get(type, serverContext);
            dataType.deserializeBinaryPrefix(rowCnt, deserializer);
            Object[] arr = dataType.deserializeBinaryBulk(rowCnt, deserializer);
            dataType.deserializeBinarySuffix(rowCnt, deserializer);
            columns[i] = ColumnFactory.createColumn(name, dataType, arr);
        }
        return new Block(rowCnt, columns, info);
    }

    public Block() {
        this(0, new IColumn[0]);
    }

    public Block(int rowCnt, IColumn[] columns) {
        this(rowCnt, columns, new BlockInfo(BlockInfo.Setting.defaultValues()));
    }

    public Block(int rowCnt, IColumn[] columns, BlockInfo settings) {
        this.rowCnt = rowCnt;
        this.columns = columns;
        this.settings = settings;
        this.rowData = new Object[columns.length];
        this.nameAndPositions = new HashMap<String, Integer>();
        this.placeholderIndexes = new int[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            this.nameAndPositions.put(columns[i].name(), i + 1);
            this.placeholderIndexes[i] = i;
        }
    }

    public int rowCnt() {
        return this.rowCnt;
    }

    public int columnCnt() {
        return this.columns.length;
    }

    public void appendRow() throws SQLException {
        int i;
        try {
            for (i = 0; i < this.columns.length; ++i) {
                this.columns[i].write(this.rowData[i]);
            }
            ++this.rowCnt;
        }
        catch (IOException | ClassCastException e) {
            throw new SQLException("Exception processing value " + this.rowData[i] + " for column: " + this.columns[i].name(), e);
        }
    }

    public void setObject(int columnIdx, Object object) {
        this.rowData[columnIdx] = object;
    }

    public int paramIdx2ColumnIdx(int paramIdx) {
        return this.placeholderIndexes[paramIdx];
    }

    public void incPlaceholderIndexes(int columnIdx) {
        int i = columnIdx;
        while (i < this.placeholderIndexes.length) {
            int n = i++;
            this.placeholderIndexes[n] = this.placeholderIndexes[n] + 1;
        }
    }

    public void writeTo(BinarySerializer serializer) throws IOException, SQLException {
        this.settings.writeTo(serializer);
        serializer.writeVarInt(this.columns.length);
        serializer.writeVarInt(this.rowCnt);
        for (IColumn column : this.columns) {
            serializer.writeUTF8StringBinary(column.name());
            serializer.writeUTF8StringBinary(column.type().name());
            column.SerializeBulkPrefix(serializer);
            column.SerializeBulk(serializer, true);
            column.SerializeBulkSuffix(serializer);
        }
    }

    public IColumn getColumn(int columnIdx) throws SQLException {
        Validate.isTrue(columnIdx < this.columns.length, "Position " + columnIdx + " is out of bound in Block.getByPosition, max position = " + (this.columns.length - 1));
        return this.columns[columnIdx];
    }

    public int getPositionByName(String columnName) throws SQLException {
        Validate.isTrue(this.nameAndPositions.containsKey(columnName), "Column '" + columnName + "' does not exist");
        return this.nameAndPositions.get(columnName);
    }

    public Object getObject(int columnIdx) throws SQLException {
        Validate.isTrue(columnIdx < this.columns.length, "Position " + columnIdx + " is out of bound in Block.getByPosition, max position = " + (this.columns.length - 1));
        return this.rowData[columnIdx];
    }

    public void initWriteBuffer() {
        ColumnWriterBufferFactory bufferFactory = ColumnWriterBufferFactory.getInstance();
        for (IColumn column : this.columns) {
            ColumnWriterBuffer writeBuffer = column.getColumnWriterBuffer();
            if (writeBuffer != null) {
                bufferFactory.recycleBuffer(writeBuffer);
            }
            column.setColumnWriterBuffer(bufferFactory.getBuffer());
        }
    }

    public void cleanup() {
        ColumnWriterBufferFactory bufferFactory = ColumnWriterBufferFactory.getInstance();
        for (IColumn column : this.columns) {
            ColumnWriterBuffer writeBuffer = column.getColumnWriterBuffer();
            if (writeBuffer == null) continue;
            bufferFactory.recycleBuffer(writeBuffer);
            column.setColumnWriterBuffer(null);
        }
    }

    public void setProgress(long readRows, long readBytes) {
        this.readRows = readRows;
        this.readBytes = readBytes;
    }

    public long readRows() {
        return this.readRows;
    }

    public long readBytes() {
        return this.readBytes;
    }
}

