/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.client.ssl;

import com.timeplus.client.NativeClient;
import com.timeplus.client.ssl.PermissiveTrustManager;
import com.timeplus.log.Logger;
import com.timeplus.log.LoggerFactory;
import com.timeplus.settings.KeyStoreConfig;
import com.timeplus.settings.SettingKey;
import com.timeplus.settings.TimeplusConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SSLContextBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(NativeClient.class);
    private TimeplusConfig config;
    private KeyStoreConfig keyStoreConfig;

    public SSLContextBuilder(TimeplusConfig config) {
        this.config = config;
        this.keyStoreConfig = new KeyStoreConfig((String)((Object)config.settings().get(SettingKey.keyStoreType)), (String)((Object)config.settings().get(SettingKey.keyStorePath)), (String)((Object)config.settings().get(SettingKey.keyStorePassword)));
    }

    public SSLContext getSSLContext() throws NoSuchAlgorithmException, KeyStoreException, IOException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        TrustManager[] trustManager = null;
        KeyManager[] keyManager = null;
        SecureRandom secureRandom = new SecureRandom();
        String sslMode = this.config.sslMode();
        LOG.debug("Client SSL mode: '" + sslMode + "'", new Object[0]);
        switch (sslMode) {
            case "disabled": {
                trustManager = new TrustManager[]{new PermissiveTrustManager()};
                keyManager = new KeyManager[]{};
                break;
            }
            case "verify_ca": {
                KeyStore keyStore = KeyStore.getInstance(this.keyStoreConfig.getKeyStoreType());
                keyStore.load(Files.newInputStream(Paths.get(this.keyStoreConfig.getKeyStorePath(), new String[0]).toFile().toPath(), new OpenOption[0]), this.keyStoreConfig.getKeyStorePassword().toCharArray());
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(keyStore, this.keyStoreConfig.getKeyStorePassword().toCharArray());
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(keyStore);
                trustManager = trustManagerFactory.getTrustManagers();
                keyManager = keyManagerFactory.getKeyManagers();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SSL mode: '" + sslMode + "'");
            }
        }
        sslContext.init(keyManager, trustManager, secureRandom);
        return sslContext;
    }
}

