/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.client;

import com.timeplus.client.NativeClient;
import com.timeplus.serde.BinarySerializer;
import com.timeplus.settings.TimeplusConfig;
import java.io.IOException;
import java.time.ZoneId;

public class NativeContext {
    private final ClientContext clientCtx;
    private final ServerContext serverCtx;
    private final NativeClient nativeClient;

    public NativeContext(ClientContext clientCtx, ServerContext serverCtx, NativeClient nativeClient) {
        this.clientCtx = clientCtx;
        this.serverCtx = serverCtx;
        this.nativeClient = nativeClient;
    }

    public ClientContext clientCtx() {
        return this.clientCtx;
    }

    public ServerContext serverCtx() {
        return this.serverCtx;
    }

    public NativeClient nativeClient() {
        return this.nativeClient;
    }

    public static class ServerContext {
        private final long majorVersion;
        private final long minorVersion;
        private final long revision;
        private final ZoneId timeZone;
        private final String displayName;
        private final TimeplusConfig configure;

        public ServerContext(long majorVersion, long minorVersion, long revision, TimeplusConfig configure, ZoneId timeZone, String displayName) {
            this.majorVersion = majorVersion;
            this.minorVersion = minorVersion;
            this.revision = revision;
            this.configure = configure;
            this.timeZone = timeZone;
            this.displayName = displayName;
        }

        public long majorVersion() {
            return this.majorVersion;
        }

        public long minorVersion() {
            return this.minorVersion;
        }

        public long revision() {
            return this.revision;
        }

        public String version() {
            return this.majorVersion + "." + this.minorVersion + "." + this.revision;
        }

        public ZoneId timeZone() {
            return this.timeZone;
        }

        public String displayName() {
            return this.displayName;
        }

        public TimeplusConfig getConfigure() {
            return this.configure;
        }
    }

    public static class ClientContext {
        public static final int TCP_KINE = 1;
        public static final byte NO_QUERY = 0;
        public static final byte INITIAL_QUERY = 1;
        public static final byte SECONDARY_QUERY = 2;
        private final String clientName;
        private final String clientHostname;
        private final String initialAddress;

        public ClientContext(String initialAddress, String clientHostname, String clientName) {
            this.clientName = clientName;
            this.clientHostname = clientHostname;
            this.initialAddress = initialAddress;
        }

        public void writeTo(BinarySerializer serializer) throws IOException {
            serializer.writeByte((byte)1);
            serializer.writeUTF8StringBinary("");
            serializer.writeUTF8StringBinary("");
            serializer.writeUTF8StringBinary(this.initialAddress);
            serializer.writeLong(0L);
            serializer.writeByte((byte)1);
            serializer.writeUTF8StringBinary("");
            serializer.writeUTF8StringBinary(this.clientHostname);
            serializer.writeUTF8StringBinary(this.clientName);
            serializer.writeVarInt(1L);
            serializer.writeVarInt(1L);
            serializer.writeVarInt(54380L);
            serializer.writeUTF8StringBinary("");
            serializer.writeVarInt(0L);
            serializer.writeVarInt(0L);
            serializer.writeByte((byte)0);
            serializer.writeVarInt(0L);
            serializer.writeVarInt(0L);
            serializer.writeVarInt(0L);
        }
    }
}

