/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.client;

import com.timeplus.buffer.SocketBuffedReader;
import com.timeplus.buffer.SocketBuffedWriter;
import com.timeplus.client.NativeContext;
import com.timeplus.client.ssl.SSLContextBuilder;
import com.timeplus.data.Block;
import com.timeplus.log.Logger;
import com.timeplus.log.LoggerFactory;
import com.timeplus.misc.Validate;
import com.timeplus.protocol.DataRequest;
import com.timeplus.protocol.DataResponse;
import com.timeplus.protocol.EOFStreamResponse;
import com.timeplus.protocol.HelloRequest;
import com.timeplus.protocol.HelloResponse;
import com.timeplus.protocol.PingRequest;
import com.timeplus.protocol.PongResponse;
import com.timeplus.protocol.QueryRequest;
import com.timeplus.protocol.Request;
import com.timeplus.protocol.Response;
import com.timeplus.serde.BinaryDeserializer;
import com.timeplus.serde.BinarySerializer;
import com.timeplus.settings.SettingKey;
import com.timeplus.settings.TimeplusConfig;
import com.timeplus.settings.TimeplusDefines;
import com.timeplus.stream.QueryResult;
import com.timeplus.stream.TimeplusQueryResult;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class NativeClient {
    private static final Logger LOG = LoggerFactory.getLogger(NativeClient.class);
    private final Socket socket;
    private final SocketAddress address;
    private final boolean compression;
    private final BinarySerializer serializer;
    private final BinaryDeserializer deserializer;

    public static NativeClient connect(TimeplusConfig config) throws SQLException {
        return NativeClient.connect(config.host(), config.port(), config);
    }

    public static NativeClient connect(String host, int port, TimeplusConfig config) throws SQLException {
        try {
            Socket socket;
            InetSocketAddress endpoint = new InetSocketAddress(host, port);
            boolean useSSL = config.ssl();
            if (useSSL) {
                LOG.debug("Client works in SSL mode!", new Object[0]);
                SSLContext context = new SSLContextBuilder(config).getSSLContext();
                SSLSocketFactory factory = context.getSocketFactory();
                socket = (SSLSocket)factory.createSocket();
            } else {
                socket = new Socket();
            }
            socket.setTcpNoDelay(true);
            socket.setSendBufferSize(TimeplusDefines.SOCKET_SEND_BUFFER_BYTES);
            socket.setReceiveBufferSize(TimeplusDefines.SOCKET_RECV_BUFFER_BYTES);
            socket.setKeepAlive(config.tcpKeepAlive());
            socket.connect(endpoint, (int)config.connectTimeout().toMillis());
            if (useSSL) {
                ((SSLSocket)socket).startHandshake();
            }
            return new NativeClient(socket);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            throw new SQLException(ex.getMessage(), ex);
        }
    }

    private NativeClient(Socket socket) throws IOException {
        this.socket = socket;
        this.address = socket.getLocalSocketAddress();
        this.compression = TimeplusDefines.COMPRESSION;
        this.serializer = new BinarySerializer(new SocketBuffedWriter(socket), this.compression);
        this.deserializer = new BinaryDeserializer(new SocketBuffedReader(socket), this.compression);
    }

    public SocketAddress address() {
        return this.address;
    }

    public boolean ping(Duration soTimeout, NativeContext.ServerContext info) {
        try {
            this.sendRequest(PingRequest.INSTANCE);
            while (true) {
                Response response;
                if ((response = this.receiveResponse(soTimeout, info)) instanceof PongResponse) {
                    return true;
                }
                LOG.debug("expect pong, skip response: {}", new Object[]{response.type()});
            }
        }
        catch (SQLException e) {
            LOG.warn(e.getMessage(), new Object[0]);
            return false;
        }
    }

    public Block receiveSampleBlock(Duration soTimeout, NativeContext.ServerContext info) throws SQLException {
        Response response;
        while (!((response = this.receiveResponse(soTimeout, info)) instanceof DataResponse)) {
            LOG.debug("expect sample block, skip response: {}", new Object[]{response.type()});
        }
        return ((DataResponse)response).block();
    }

    public void sendHello(String client, long reversion, String db, String user, String password) throws SQLException {
        this.sendRequest(new HelloRequest(client, reversion, db, user, password));
    }

    public void sendQuery(String query, NativeContext.ClientContext info, Map<SettingKey, Serializable> settings) throws SQLException {
        this.sendQuery((String)((Object)settings.getOrDefault(SettingKey.query_id, (Serializable)((Object)UUID.randomUUID().toString()))), 2, info, query, settings);
    }

    public void sendData(Block data) throws SQLException {
        this.sendRequest(new DataRequest("", data));
    }

    public HelloResponse receiveHello(Duration soTimeout, NativeContext.ServerContext info) throws SQLException {
        Response response = this.receiveResponse(soTimeout, info);
        Validate.isTrue(response instanceof HelloResponse, "Expect Hello Response.");
        return (HelloResponse)response;
    }

    public EOFStreamResponse receiveEndOfStream(Duration soTimeout, NativeContext.ServerContext info) throws SQLException {
        Response response = this.receiveResponse(soTimeout, info);
        Validate.isTrue(response instanceof EOFStreamResponse, "Expect EOFStream Response.");
        return (EOFStreamResponse)response;
    }

    public QueryResult receiveQuery(Duration soTimeout, NativeContext.ServerContext info) {
        return new TimeplusQueryResult(() -> this.receiveResponse(soTimeout, info));
    }

    public void silentDisconnect() {
        try {
            this.disconnect();
        }
        catch (Throwable th) {
            LOG.debug("disconnect throw exception.", th);
        }
    }

    public void disconnect() throws SQLException {
        try {
            if (this.socket.isClosed()) {
                LOG.info("socket already closed, ignore", new Object[0]);
                return;
            }
            LOG.trace("flush and close socket", new Object[0]);
            this.serializer.flushToTarget(true);
            this.socket.close();
        }
        catch (IOException ex) {
            throw new SQLException(ex.getMessage(), ex);
        }
    }

    private void sendQuery(String id, int stage, NativeContext.ClientContext info, String query, Map<SettingKey, Serializable> settings) throws SQLException {
        this.sendRequest(new QueryRequest(id, info, stage, this.compression, query, settings));
    }

    private void sendRequest(Request request) throws SQLException {
        try {
            LOG.trace("send request: {}", new Object[]{request.type()});
            request.writeTo(this.serializer);
            this.serializer.flushToTarget(true);
        }
        catch (IOException ex) {
            throw new SQLException(ex.getMessage(), ex);
        }
    }

    private Response receiveResponse(Duration soTimeout, NativeContext.ServerContext info) throws SQLException {
        try {
            this.socket.setSoTimeout((int)soTimeout.toMillis());
            Response response = Response.readFrom(this.deserializer, info);
            LOG.trace("recv response: {}", new Object[]{response.type()});
            return response;
        }
        catch (IOException ex) {
            throw new SQLException(ex.getMessage(), ex);
        }
    }
}

