/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.buffer;

import com.timeplus.buffer.BuffedWriter;
import com.timeplus.misc.BytesHelper;
import com.timeplus.misc.ClickHouseCityHash;
import com.timeplus.repackaged.io.airlift.compress.Compressor;
import com.timeplus.repackaged.io.airlift.compress.lz4.Lz4Compressor;
import com.timeplus.repackaged.io.airlift.compress.zstd.ZstdCompressor;
import java.io.IOException;

public class CompressedBuffedWriter
implements BuffedWriter,
BytesHelper {
    private final int capacity;
    private final byte[] writtenBuf;
    private final BuffedWriter writer;
    private final Compressor lz4Compressor = new Lz4Compressor();
    private final Compressor zstdCompressor = new ZstdCompressor();
    private int position;

    public CompressedBuffedWriter(int capacity, BuffedWriter writer) {
        this.capacity = capacity;
        this.writtenBuf = new byte[capacity];
        this.writer = writer;
    }

    @Override
    public void writeBinary(byte byt) throws IOException {
        this.writtenBuf[this.position++] = byt;
        this.flushToTarget(false);
    }

    @Override
    public void writeBinary(byte[] bytes, int offset, int length) throws IOException {
        while (this.remaining() < length) {
            int num = this.remaining();
            System.arraycopy(bytes, offset, this.writtenBuf, this.position, this.remaining());
            this.position += num;
            this.flushToTarget(false);
            offset += num;
            length -= num;
        }
        System.arraycopy(bytes, offset, this.writtenBuf, this.position, length);
        this.position += length;
        this.flushToTarget(false);
    }

    @Override
    public void flushToTarget(boolean force) throws IOException {
        if (this.position > 0 && (force || !this.hasRemaining())) {
            int maxLen = this.lz4Compressor.maxCompressedLength(this.position);
            byte[] compressedBuffer = new byte[maxLen + 9 + 16];
            int res = this.lz4Compressor.compress(this.writtenBuf, 0, this.position, compressedBuffer, 25, compressedBuffer.length);
            compressedBuffer[16] = -126;
            int compressedSize = res + 9;
            System.arraycopy(this.getBytesLE(compressedSize), 0, compressedBuffer, 17, 4);
            System.arraycopy(this.getBytesLE(this.position), 0, compressedBuffer, 21, 4);
            long[] checksum = ClickHouseCityHash.cityHash128(compressedBuffer, 16, compressedSize);
            System.arraycopy(this.getBytesLE(checksum[0]), 0, compressedBuffer, 0, 8);
            System.arraycopy(this.getBytesLE(checksum[1]), 0, compressedBuffer, 8, 8);
            this.writer.writeBinary(compressedBuffer, 0, compressedSize + 16);
            this.position = 0;
        }
    }

    private boolean hasRemaining() {
        return this.position < this.capacity;
    }

    private int remaining() {
        return this.capacity - this.position;
    }
}

