/*
 * Decompiled with CFR 0.152.
 */
package com.timeplus.buffer;

import com.timeplus.buffer.BuffedReader;
import com.timeplus.misc.BytesHelper;
import com.timeplus.repackaged.io.airlift.compress.Decompressor;
import com.timeplus.repackaged.io.airlift.compress.lz4.Lz4Decompressor;
import com.timeplus.repackaged.io.airlift.compress.zstd.ZstdDecompressor;
import java.io.IOException;

public class CompressedBuffedReader
implements BuffedReader,
BytesHelper {
    private int position;
    private int capacity;
    private byte[] decompressed;
    private final BuffedReader buf;
    private final Decompressor lz4Decompressor = new Lz4Decompressor();
    private final Decompressor zstdDecompressor = new ZstdDecompressor();
    private static final int NONE = 2;
    private static final int LZ4 = 130;
    private static final int ZSTD = 144;

    public CompressedBuffedReader(BuffedReader buf) {
        this.buf = buf;
    }

    @Override
    public int readBinary() throws IOException {
        if (this.position == this.capacity) {
            this.decompressed = this.readCompressedData();
            this.position = 0;
            this.capacity = this.decompressed.length;
        }
        return this.decompressed[this.position++];
    }

    @Override
    public int readBinary(byte[] bytes) throws IOException {
        int i = 0;
        while (i < bytes.length) {
            int padding;
            int fillLength;
            if (this.position == this.capacity) {
                this.decompressed = this.readCompressedData();
                this.position = 0;
                this.capacity = this.decompressed.length;
            }
            if ((fillLength = Math.min(padding = bytes.length - i, this.capacity - this.position)) <= 0) continue;
            System.arraycopy(this.decompressed, this.position, bytes, i, fillLength);
            i += fillLength;
            this.position += fillLength;
        }
        return bytes.length;
    }

    private byte[] readCompressedData() throws IOException {
        this.buf.readBinary(new byte[16]);
        byte[] compressedHeader = new byte[9];
        if (this.buf.readBinary(compressedHeader) != 9) {
            throw new IOException("Invalid compression header");
        }
        int method = compressedHeader[0] & 0xFF;
        int compressedSize = this.getIntLE(compressedHeader, 1);
        int decompressedSize = this.getIntLE(compressedHeader, 5);
        switch (method) {
            case 130: {
                return this.readLZ4CompressedData(compressedSize - 9, decompressedSize);
            }
            case 2: {
                return this.readNoneCompressedData(decompressedSize);
            }
        }
        throw new UnsupportedOperationException("Unknown compression magic code: " + method);
    }

    private byte[] readNoneCompressedData(int size) throws IOException {
        byte[] decompressed = new byte[size];
        if (this.buf.readBinary(decompressed) != size) {
            throw new IOException("Cannot decompress use None method.");
        }
        return decompressed;
    }

    private byte[] readLZ4CompressedData(int compressedSize, int decompressedSize) throws IOException {
        byte[] decompressed;
        byte[] compressed = new byte[compressedSize];
        if (this.buf.readBinary(compressed) == compressedSize && this.lz4Decompressor.decompress(compressed, 0, compressedSize, decompressed = new byte[decompressedSize], 0, decompressedSize) == decompressedSize) {
            return decompressed;
        }
        throw new IOException("Cannot decompress use LZ4 method.");
    }
}

