/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.send.parameters;

import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.send.parameters.ParameterHolder;
import com.oceanbase.jdbc.internal.io.output.PacketOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public class StringParameter
implements Cloneable,
ParameterHolder {
    private final String stringValue;
    private final boolean noBackslashEscapes;
    private final String characterEncoding;
    private final Charset charset;

    private boolean needEscape(String str, int length) {
        boolean needed = false;
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\u0000': 
                case '\n': 
                case '\r': 
                case '\u001a': 
                case '\"': 
                case '\'': 
                case '\\': {
                    needed = true;
                }
            }
            if (needed) break;
        }
        return needed;
    }

    private String escapedString(String str, int length) {
        StringBuilder stringBuilder = new StringBuilder((int)((double)str.length() * 1.1));
        block10: for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\u0000': {
                    stringBuilder.append('\\');
                    stringBuilder.append('0');
                    continue block10;
                }
                case '\n': {
                    stringBuilder.append('\\');
                    stringBuilder.append('n');
                    continue block10;
                }
                case '\r': {
                    stringBuilder.append('\\');
                    stringBuilder.append('r');
                    continue block10;
                }
                case '\\': {
                    stringBuilder.append('\\');
                    stringBuilder.append('\\');
                    continue block10;
                }
                case '\'': {
                    stringBuilder.append('\\');
                    stringBuilder.append('\'');
                    continue block10;
                }
                case '\"': {
                    stringBuilder.append('\"');
                    continue block10;
                }
                case '\u001a': {
                    stringBuilder.append('\\');
                    stringBuilder.append('Z');
                    continue block10;
                }
                case '\u00a5': 
                case '\u20a9': {
                    CharsetEncoder charsetEncoder = Charset.forName(this.characterEncoding).newEncoder();
                    if (charsetEncoder != null) {
                        CharBuffer charBuffer = CharBuffer.allocate(1);
                        ByteBuffer byteBuffer = ByteBuffer.allocate(1);
                        charBuffer.put(c);
                        charBuffer.position(0);
                        charsetEncoder.encode(charBuffer, byteBuffer, true);
                        if (byteBuffer.get(0) == 92) {
                            stringBuilder.append('\\');
                        }
                    }
                    stringBuilder.append(c);
                    continue block10;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public StringParameter(String str, boolean noBackslashEscapes, String characterEncoding) {
        this.stringValue = str;
        this.noBackslashEscapes = noBackslashEscapes;
        this.characterEncoding = characterEncoding;
        this.charset = Charset.forName(characterEncoding);
    }

    @Override
    public void writeTo(PacketOutputStream pos) throws IOException {
        pos.write(this.stringValue, true, this.noBackslashEscapes);
    }

    @Override
    public int getApproximateTextProtocolLength() {
        return this.stringValue.length() * 3;
    }

    @Override
    public void writeBinary(PacketOutputStream pos) throws IOException {
        byte[] bytes = this.stringValue.getBytes(this.charset);
        pos.writeFieldLength(bytes.length);
        pos.write(bytes);
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.VARCHAR;
    }

    @Override
    public String toString() {
        String tmp = this.stringValue;
        if (this.needEscape(this.stringValue, this.stringValue.length())) {
            tmp = this.escapedString(this.stringValue, this.stringValue.length());
        }
        if (tmp.length() < 1024) {
            return "'" + tmp + "'";
        }
        return "'" + tmp.substring(0, 1024) + "...'";
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public boolean isLongData() {
        return false;
    }
}

