/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.send.parameters;

import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.send.parameters.ParameterHolder;
import com.oceanbase.jdbc.internal.io.output.PacketOutputStream;
import java.io.IOException;

public class ByteParameter
implements Cloneable,
ParameterHolder {
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    private final int value;

    public ByteParameter(byte value) {
        this.value = value;
    }

    @Override
    public void writeTo(PacketOutputStream os) throws IOException {
        os.write(String.valueOf(this.value).getBytes());
    }

    @Override
    public int getApproximateTextProtocolLength() {
        return String.valueOf(this.value).length();
    }

    @Override
    public void writeBinary(PacketOutputStream pos) throws IOException {
        pos.write(this.value);
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.TINYINT;
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public boolean isLongData() {
        return false;
    }
}

