/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.util;

import com.oceanbase.jdbc.util.Options;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

public class HttpClient {
    private static long ifModifiedSince;
    private static long lastModified;

    public static String doGet(String httpUrl, Options options) throws IOException {
        HttpURLConnection connection = null;
        String result = null;
        try {
            URL url = new URL(httpUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(options.httpConnectTimeout);
            connection.setReadTimeout(options.httpReadTimeout);
            ifModifiedSince = connection.getIfModifiedSince();
            connection.setIfModifiedSince(lastModified);
            ifModifiedSince = connection.getIfModifiedSince();
            connection.connect();
            lastModified = connection.getLastModified();
            if (connection.getResponseCode() == 200) {
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
                StringBuffer response = new StringBuffer();
                String inputLine = null;
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                result = response.toString();
            }
            String string = result;
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

