/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.failover.impl;

import com.oceanbase.jdbc.internal.failover.BlackList.BlackListConfig;
import com.oceanbase.jdbc.internal.failover.BlackList.append.AppendStrategy;
import com.oceanbase.jdbc.internal.failover.BlackList.append.NormalAppend;
import com.oceanbase.jdbc.internal.failover.BlackList.append.RetryDuration;
import com.oceanbase.jdbc.internal.failover.BlackList.recover.TimeoutRecover;
import com.oceanbase.jdbc.internal.failover.LoadBalanceStrategy.BalanceStrategy;
import com.oceanbase.jdbc.internal.failover.LoadBalanceStrategy.GroupBalanceStrategy;
import com.oceanbase.jdbc.internal.failover.LoadBalanceStrategy.GroupRotationStrategy;
import com.oceanbase.jdbc.internal.failover.LoadBalanceStrategy.RandomStrategy;
import com.oceanbase.jdbc.internal.failover.LoadBalanceStrategy.RotationStrategy;
import com.oceanbase.jdbc.internal.failover.LoadBalanceStrategy.ServerAffinityStrategy;
import com.oceanbase.jdbc.internal.failover.impl.LoadBalanceAddressList;
import com.oceanbase.jdbc.internal.failover.impl.LoadBalanceHostAddress;
import com.oceanbase.jdbc.internal.util.constant.HaMode;
import java.io.InvalidObjectException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class LoadBalanceInfo {
    HaMode haMode;
    String serviceName;
    int retryAllDowns;
    GroupBalanceStrategy groupBalanceStrategy;
    HashMap<String, String> groupBalanceStrategyConfigs;
    BalanceStrategy balanceStrategy;
    HashMap<String, String> balanceStrategyConfigs;
    BlackListConfig blackListConfig;
    List<LoadBalanceAddressList> groups;

    public LoadBalanceInfo() {
        this.groups = new ArrayList<LoadBalanceAddressList>();
        this.blackListConfig = new BlackListConfig();
        this.groupBalanceStrategyConfigs = new HashMap();
        this.groupBalanceStrategyConfigs.put("NAME", "ROTATION");
        this.balanceStrategyConfigs = new HashMap();
        this.balanceStrategyConfigs.put("NAME", "RANDOM");
        this.retryAllDowns = 120;
    }

    public LoadBalanceInfo(GroupBalanceStrategy groupBalanceStrategy, BalanceStrategy balanceStrategy, BlackListConfig blackListConfig, List<LoadBalanceAddressList> groups) {
        this.groupBalanceStrategy = groupBalanceStrategy;
        this.balanceStrategy = balanceStrategy;
        this.blackListConfig = blackListConfig;
        this.groups = groups;
    }

    public LoadBalanceInfo(HashMap map) throws InvalidObjectException {
        HashMap connectMap = (HashMap)map.get("CONNECT_DATA");
        if (connectMap != null) {
            this.serviceName = (String)connectMap.get("SERVICE_NAME");
        }
        try {
            this.retryAllDowns = (Integer)map.get("OBLB_RETRY_ALL_DOWNS");
        }
        catch (Exception e) {
            this.retryAllDowns = 120;
        }
        this.groupBalanceStrategy = this.resolveGroupBalanceStrategy((String)map.get("OBLB_GROUP_STRATEGY"));
        this.balanceStrategy = this.resolveBalanceStrategy((String)map.get("OBLB_STRATEGY"), true);
        this.blackListConfig = this.resolveBlackListConfig((HashMap)map.get("OBLB_BLACKLIST"));
        this.groups = new ArrayList<LoadBalanceAddressList>();
        ArrayList groupList = (ArrayList)map.get("ADDRESS_LIST");
        if (groupList == null || groupList.isEmpty()) {
            throw new InvalidObjectException("ADDRESS_LIST can't be empty!");
        }
        for (HashMap groupMap : groupList) {
            BalanceStrategy balanceStrategy = this.resolveBalanceStrategy((String)groupMap.get("OBLB_STRATEGY"), false);
            List<LoadBalanceHostAddress> balanceAddressList = this.resolveAddressList((ArrayList)groupMap.get("ADDRESS"), balanceStrategy);
            LoadBalanceAddressList group = new LoadBalanceAddressList(balanceStrategy, null, balanceAddressList);
            this.groups.add(group);
        }
    }

    public String toString() {
        return "LoadBalanceInfo{haMode=" + (Object)((Object)this.haMode) + ", serviceName='" + this.serviceName + '\'' + ", groupBalanceStrategy=" + this.groupBalanceStrategy + ", balanceStrategy=" + this.balanceStrategy + ", blackListConfig=" + this.blackListConfig + ", retryAllDowns=" + this.retryAllDowns + ", groups=" + this.groups + '}';
    }

    public String toJson() {
        StringBuilder json = new StringBuilder("\"OBLB\":\"ON\",\"OBLB_RETRY_ALL_DOWNS\":" + this.retryAllDowns);
        if (this.serviceName != null) {
            json.append(",\"CONNECT_DATA\":{\"SERVICE_NAME\":\"").append(this.serviceName).append("\"}");
        }
        if (this.groupBalanceStrategy != null) {
            json.append(",").append(this.groupBalanceStrategy.toJson());
        }
        if (this.balanceStrategy != null) {
            json.append(",").append(this.balanceStrategy.toJson());
        }
        if (this.blackListConfig != null) {
            json.append(",").append(this.blackListConfig.toJson());
        }
        if (this.groups != null && this.groups.size() > 0) {
            json.append(",").append("\"ADDRESS_LIST\": [");
            boolean atLeastOneGroup = false;
            for (LoadBalanceAddressList group : this.groups) {
                if (atLeastOneGroup) {
                    json.append(",");
                } else {
                    atLeastOneGroup = true;
                }
                json.append("{").append(group.toJson()).append("}");
            }
            json.append("]");
        }
        return json.toString();
    }

    private GroupBalanceStrategy resolveGroupBalanceStrategy(String strVal) {
        GroupRotationStrategy groupBalanceStrategy;
        if (strVal != null) {
            switch (strVal) {
                default: 
            }
            groupBalanceStrategy = new GroupRotationStrategy();
        } else {
            groupBalanceStrategy = new GroupRotationStrategy();
        }
        return groupBalanceStrategy;
    }

    private BalanceStrategy resolveBalanceStrategy(String strVal, boolean isGlobal) {
        BalanceStrategy balanceStrategy;
        if (strVal != null) {
            switch (strVal) {
                case "ROTATION": {
                    balanceStrategy = new RotationStrategy();
                    break;
                }
                case "SERVERAFFINITY": {
                    balanceStrategy = new ServerAffinityStrategy();
                    break;
                }
                default: {
                    balanceStrategy = new RandomStrategy();
                    break;
                }
            }
        } else {
            balanceStrategy = isGlobal ? new RandomStrategy() : this.balanceStrategy;
        }
        return balanceStrategy;
    }

    private BlackListConfig resolveBlackListConfig(HashMap blacklistMap) {
        BlackListConfig blackListConfig = new BlackListConfig(true);
        if (blacklistMap != null) {
            HashMap appendMap;
            HashMap removeMap = (HashMap)blacklistMap.get("REMOVE_STRATEGY");
            if (removeMap != null) {
                String name;
                switch (name = (String)removeMap.get("NAME")) {
                    default: 
                }
                long timeout = ((Integer)removeMap.get("TIMEOUT")).longValue();
                TimeoutRecover removeStrategy = new TimeoutRecover(timeout);
                blackListConfig.setRemoveStrategy(removeStrategy);
            }
            if ((appendMap = (HashMap)blacklistMap.get("APPEND_STRATEGY")) != null) {
                AppendStrategy appendStrategy;
                String name;
                switch (name = (String)appendMap.get("NAME")) {
                    case "RETRYDURATION": {
                        int retryTimes = (Integer)appendMap.get("RETRYTIMES");
                        long duration = ((Integer)appendMap.get("DURATION")).longValue();
                        appendStrategy = new RetryDuration(duration, retryTimes);
                        break;
                    }
                    default: {
                        appendStrategy = new NormalAppend();
                    }
                }
                blackListConfig.setAppendStrategy(appendStrategy);
            }
        }
        return blackListConfig;
    }

    private List<LoadBalanceHostAddress> resolveAddressList(ArrayList addressList, BalanceStrategy balanceStrategy) throws InvalidObjectException {
        if (addressList == null || addressList.isEmpty()) {
            throw new InvalidObjectException("ADDRESS can't be empty!");
        }
        ArrayList<LoadBalanceHostAddress> balanceAddressList = null;
        for (HashMap addressMap : addressList) {
            String host = (String)addressMap.get("HOST");
            int port = (Integer)addressMap.get("PORT");
            LoadBalanceHostAddress balanceAddress = new LoadBalanceHostAddress(host, port);
            if (balanceStrategy instanceof ServerAffinityStrategy) {
                int weight = (Integer)addressMap.get("WEIGHT");
                balanceAddress.setWeight(weight);
            }
            if (balanceAddressList == null) {
                balanceAddressList = new ArrayList<LoadBalanceHostAddress>();
            }
            balanceAddressList.add(balanceAddress);
        }
        return balanceAddressList;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public HaMode getHaMode() {
        return this.haMode;
    }

    public void setHaMode(HaMode haMode) {
        this.haMode = haMode;
    }

    public GroupBalanceStrategy getGroupBalanceStrategy() {
        return this.groupBalanceStrategy;
    }

    public void setGroupBalanceStrategy(GroupBalanceStrategy groupBalanceStrategy) {
        this.groupBalanceStrategy = groupBalanceStrategy;
    }

    public BalanceStrategy getBalanceStrategy() {
        return this.balanceStrategy;
    }

    public void setBalanceStrategy(BalanceStrategy balanceStrategy) {
        this.balanceStrategy = balanceStrategy;
    }

    public BlackListConfig getBlackListConfig() {
        return this.blackListConfig;
    }

    public void setBlackListConfig(BlackListConfig blackListConfig) {
        this.blackListConfig = blackListConfig;
    }

    public int getRetryAllDowns() {
        return this.retryAllDowns;
    }

    public void setRetryAllDowns(int retryAllDowns) {
        this.retryAllDowns = retryAllDowns;
    }

    public List<LoadBalanceAddressList> getGroups() {
        return this.groups;
    }

    public void setGroups(List<LoadBalanceAddressList> groups) {
        this.groups = groups;
    }

    public HashMap<String, String> getGroupBalanceStrategyConfigs() {
        return this.groupBalanceStrategyConfigs;
    }

    public void setGroupBalanceStrategyConfigs(HashMap<String, String> groupBalanceStrategyConfigs) {
        this.groupBalanceStrategyConfigs = groupBalanceStrategyConfigs;
    }

    public HashMap<String, String> getBalanceStrategyConfigs() {
        return this.balanceStrategyConfigs;
    }

    public void setBalanceStrategyConfigs(HashMap<String, String> balanceStrategyConfigs) {
        this.balanceStrategyConfigs = balanceStrategyConfigs;
    }
}

