/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.send.parameters;

import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.send.parameters.ParameterHolder;
import com.oceanbase.jdbc.internal.io.output.PacketOutputStream;
import java.io.IOException;

public class BooleanParameter
implements Cloneable,
ParameterHolder {
    private final boolean value;

    public BooleanParameter(boolean value) {
        this.value = value;
    }

    @Override
    public void writeTo(PacketOutputStream os) throws IOException {
        os.write(this.value ? 49 : 48);
    }

    @Override
    public int getApproximateTextProtocolLength() {
        return 1;
    }

    @Override
    public void writeBinary(PacketOutputStream pos) throws IOException {
        pos.write(this.value ? 1 : 0);
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.TINYINT;
    }

    @Override
    public String toString() {
        return Boolean.toString(this.value);
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public boolean isLongData() {
        return false;
    }
}

