/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.authentication;

import com.oceanbase.jdbc.Driver;
import com.oceanbase.jdbc.authentication.AuthenticationPlugin;
import java.sql.SQLException;
import java.util.ServiceLoader;

public class AuthenticationPluginLoader {
    private static ServiceLoader<AuthenticationPlugin> loader = ServiceLoader.load(AuthenticationPlugin.class, Driver.class.getClassLoader());

    public static AuthenticationPlugin get(String type) throws SQLException {
        if (type == null || type.isEmpty()) {
            return null;
        }
        for (AuthenticationPlugin implClass : loader) {
            if (!type.equals(implClass.type())) continue;
            return implClass;
        }
        throw new SQLException("Client does not support authentication protocol requested by server. plugin type was = '" + type + "'", "08004", 1251);
    }
}

