/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc;

import com.oceanbase.jdbc.CallParameter;
import com.oceanbase.jdbc.CallableParameterMetaData;
import com.oceanbase.jdbc.OceanBaseConnection;
import com.oceanbase.jdbc.ServerSidePreparedStatement;
import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.read.resultset.SelectResultSet;
import com.oceanbase.jdbc.internal.util.exceptions.ExceptionFactory;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public abstract class CallableProcedureStatement
extends ServerSidePreparedStatement
implements CallableStatement,
Cloneable {
    protected List<CallParameter> params;
    protected int[] outputParameterMapper;
    protected CallableParameterMetaData parameterMetadata;
    protected boolean hasInOutParameters;
    protected String arguments;
    private boolean firstMapName = true;
    protected boolean resetSpecialParamIndex;

    public CallableProcedureStatement(boolean isObFuction, OceanBaseConnection connection, String sql, int resultSetScrollType, int resultSetConcurrency, ExceptionFactory exceptionFactory) throws SQLException {
        super(isObFuction, connection, sql, resultSetScrollType, resultSetConcurrency, 2, exceptionFactory);
    }

    @Override
    public CallableProcedureStatement clone(OceanBaseConnection connection) throws CloneNotSupportedException {
        CallableProcedureStatement clone = (CallableProcedureStatement)super.clone(connection);
        clone.params = this.params;
        clone.parameterMetadata = this.parameterMetadata;
        clone.hasInOutParameters = this.hasInOutParameters;
        clone.outputParameterMapper = this.outputParameterMapper;
        return clone;
    }

    protected abstract SelectResultSet getOutputResult() throws SQLException;

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.parameterMetadata.readMetadataFromDbIfRequired();
        return this.parameterMetadata;
    }

    private int nameToIndex(String parameterName) throws SQLException {
        this.parameterMetadata.readMetadataFromDbIfRequired(this.originalSql, this.arguments, this.isObFunction);
        if (this.protocol.isOracleMode() && (this.parameterMetadata.getParameterCount() == 0 || this.arguments == null)) {
            return this.getIndexAndFillParams(parameterName);
        }
        for (int i = 1; i <= this.parameterMetadata.getParameterCount(); ++i) {
            String name;
            if (!this.protocol.isOracleMode()) {
                name = this.parameterMetadata.placeholderParams.get(i - 1).getName();
                name = name.replaceAll("\\`(\\w+)\\`", "$1");
            } else {
                name = this.parameterMetadata.getName(i);
            }
            if (name == null || !name.equalsIgnoreCase(parameterName)) continue;
            if (this.protocol.isOracleMode()) {
                return this.getIndexAndFillParams(parameterName);
            }
            return i;
        }
        if (this.protocol.isOracleMode()) {
            return this.getIndexAndFillParams(parameterName);
        }
        throw new SQLException("there is no parameter with the name " + parameterName);
    }

    private int getIndexAndFillParams(String parameterName) {
        if (this.firstMapName && (this.arguments == null || !this.arguments.contains("=>"))) {
            this.params.clear();
            this.firstMapName = false;
        }
        for (int i = 1; i <= this.params.size(); ++i) {
            String name = this.params.get(i - 1).getName();
            if (name == null || !name.equalsIgnoreCase(parameterName)) continue;
            return i;
        }
        CallParameter param = new CallParameter();
        param.setName(parameterName);
        param.setIndex(this.params.size());
        this.params.add(param);
        return this.params.size();
    }

    private int nameToOutputIndex(String parameterName) throws SQLException {
        String name;
        int i;
        if (this.protocol.isOracleMode()) {
            for (i = 0; i < this.params.size(); ++i) {
                name = this.params.get(i).getName();
                if (name == null || !name.equalsIgnoreCase(parameterName)) continue;
                if (this.outputParameterMapper[i] == -1) {
                    throw new SQLException("Parameter '" + parameterName + "' is not declared as output parameter with method registerOutParameter");
                }
                return this.outputParameterMapper[i];
            }
        }
        this.parameterMetadata.readMetadataFromDbIfRequired();
        for (i = 0; i < this.parameterMetadata.getParameterCount(); ++i) {
            name = this.parameterMetadata.getName(i + 1);
            if (!this.protocol.isOracleMode()) {
                name = name.replaceAll("\\`(\\w+)\\`", "$1");
            }
            if (name == null || !name.equalsIgnoreCase(parameterName)) continue;
            if (this.outputParameterMapper[i] == -1) {
                throw new SQLException("Parameter '" + parameterName + "' is not declared as output parameter with method registerOutParameter");
            }
            return this.outputParameterMapper[i];
        }
        throw new SQLException("there is no parameter with the name " + parameterName);
    }

    private int indexToOutputIndex(int parameterIndex) throws SQLException {
        try {
            int outputIndex;
            if (this.isObFunction && !this.protocol.isOracleMode()) {
                return 1;
            }
            if (this.arguments != null && this.arguments.length() > 0 && this.arguments.contains("=>") && !this.resetSpecialParamIndex) {
                for (int i = 0; i < this.outputParameterMapper.length; ++i) {
                    this.outputParameterMapper[i] = this.params.get(i).getIndex() + 1;
                }
                this.resetSpecialParamIndex = true;
            }
            if ((outputIndex = this.outputParameterMapper[parameterIndex - 1]) == -1) {
                throw new SQLException("Parameter in index '" + parameterIndex + "' is not declared as output parameter with method registerOutParameter");
            }
            return outputIndex;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (parameterIndex < 1) {
                throw new SQLException("Index " + parameterIndex + " must at minimum be 1");
            }
            throw new SQLException("Index " + parameterIndex + " must at maximum be " + this.params.size());
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.getOutputResult().wasNull();
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        return this.getOutputResult().getString(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        return this.getOutputResult().getString(this.nameToOutputIndex(parameterName));
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        return this.getOutputResult().getBoolean(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        return this.getOutputResult().getBoolean(this.nameToOutputIndex(parameterName));
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        return this.getOutputResult().getByte(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        return this.getOutputResult().getByte(this.nameToOutputIndex(parameterName));
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        return this.getOutputResult().getShort(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        return this.getOutputResult().getShort(this.nameToOutputIndex(parameterName));
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        return this.getOutputResult().getInt(this.nameToOutputIndex(parameterName));
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        return this.getOutputResult().getInt(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        return this.getOutputResult().getLong(this.nameToOutputIndex(parameterName));
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        return this.getOutputResult().getLong(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        return this.getOutputResult().getFloat(this.nameToOutputIndex(parameterName));
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        return this.getOutputResult().getFloat(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        return this.getOutputResult().getDouble(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        return this.getOutputResult().getDouble(this.nameToOutputIndex(parameterName));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        return this.getOutputResult().getBigDecimal(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        return this.getOutputResult().getBigDecimal(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        return this.getOutputResult().getBigDecimal(this.nameToOutputIndex(parameterName));
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        return this.getOutputResult().getBytes(this.nameToOutputIndex(parameterName));
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        return this.getOutputResult().getBytes(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        return this.getOutputResult().getDate(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        return this.getOutputResult().getDate(this.nameToOutputIndex(parameterName));
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        return this.getOutputResult().getDate(this.nameToOutputIndex(parameterName), cal);
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        return this.getOutputResult().getDate(this.indexToOutputIndex(parameterIndex), cal);
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        return this.getOutputResult().getTime(this.indexToOutputIndex(parameterIndex), cal);
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        return this.getOutputResult().getTime(this.nameToOutputIndex(parameterName));
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        return this.getOutputResult().getTime(this.nameToOutputIndex(parameterName), cal);
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        return this.getOutputResult().getTime(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return this.getOutputResult().getTimestamp(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        return this.getOutputResult().getTimestamp(this.indexToOutputIndex(parameterIndex), cal);
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        return this.getOutputResult().getTimestamp(this.nameToOutputIndex(parameterName));
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        return this.getOutputResult().getTimestamp(this.nameToOutputIndex(parameterName), cal);
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        return this.getOutputResult().getObject(this.indexToOutputIndex(parameterIndex), map);
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        Class classType = ColumnType.convertSqlTypeToClass(this.getParameter(parameterIndex).getOutputSqlType());
        if (classType != null) {
            return this.getOutputResult().getObject(this.indexToOutputIndex(parameterIndex), classType);
        }
        return this.getOutputResult().getObject(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        int index = this.nameToIndex(parameterName);
        Class classType = ColumnType.convertSqlTypeToClass(this.getParameter(index).getOutputSqlType());
        if (classType != null) {
            return this.getOutputResult().getObject(this.indexToOutputIndex(index), classType);
        }
        return this.getOutputResult().getObject(this.indexToOutputIndex(index));
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        return this.getOutputResult().getObject(this.nameToOutputIndex(parameterName), map);
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        return this.getOutputResult().getObject(this.indexToOutputIndex(parameterIndex), type);
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        return this.getOutputResult().getObject(this.nameToOutputIndex(parameterName), type);
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        return this.getOutputResult().getRef(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        return this.getOutputResult().getRef(this.nameToOutputIndex(parameterName));
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        return this.getOutputResult().getBlob(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        return this.getOutputResult().getBlob(this.nameToOutputIndex(parameterName));
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        return this.getOutputResult().getClob(this.nameToOutputIndex(parameterName));
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        return this.getOutputResult().getClob(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        return this.getOutputResult().getArray(this.nameToOutputIndex(parameterName));
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        return this.getOutputResult().getArray(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        return this.getOutputResult().getURL(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        return this.getOutputResult().getURL(this.nameToOutputIndex(parameterName));
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        throw this.exceptionFactory.notSupported("RowIDs not supported");
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        throw this.exceptionFactory.notSupported("RowIDs not supported");
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        return this.getOutputResult().getNClob(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        return this.getOutputResult().getNClob(this.nameToOutputIndex(parameterName));
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        throw this.exceptionFactory.notSupported("SQLXML not supported");
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        throw this.exceptionFactory.notSupported("SQLXML not supported");
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        return this.getOutputResult().getString(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        return this.getOutputResult().getString(this.nameToOutputIndex(parameterName));
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        return this.getOutputResult().getCharacterStream(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        return this.getOutputResult().getCharacterStream(this.nameToOutputIndex(parameterName));
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        return this.getOutputResult().getCharacterStream(this.indexToOutputIndex(parameterIndex));
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        return this.getOutputResult().getCharacterStream(this.nameToOutputIndex(parameterName));
    }

    private void checkIsOutputParam(int paramIndex) throws SQLException {
        if (this.isObFunction && paramIndex == 1) {
            return;
        }
        CallParameter param = this.params.get(paramIndex - 1);
        if (!param.isOutput()) {
            throw new SQLException("Parameter number " + paramIndex + "is not an OUT parameter");
        }
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        if (this.isObFunction && parameterIndex == 1) {
            return;
        }
        CallParameter callParameter = this.getParameter(parameterIndex);
        callParameter.setOutputSqlType(sqlType);
        callParameter.setTypeName(typeName);
        callParameter.setOutput(true);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType, -1);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        CallParameter placeHolderParameter;
        CallParameter callParameter = this.getParameter(parameterIndex);
        callParameter.setOutput(true);
        callParameter.setOutputSqlType(sqlType);
        callParameter.setScale(scale);
        if (this.protocol.isOracleMode() && null != (placeHolderParameter = this.parameterMetadata.getPlaceholderParam(parameterIndex - 1))) {
            placeHolderParameter.setOutput(true);
            placeHolderParameter.setOutputSqlType(sqlType);
            placeHolderParameter.setScale(scale);
        }
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.registerOutParameter(this.nameToIndex(parameterName), sqlType);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(this.nameToIndex(parameterName), sqlType, scale);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.registerOutParameter(this.nameToIndex(parameterName), sqlType, typeName);
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType) throws SQLException {
        this.registerOutParameter(parameterIndex, (int)sqlType.getVendorTypeNumber());
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterIndex, (int)sqlType.getVendorTypeNumber(), scale);
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType, String typeName) throws SQLException {
        this.registerOutParameter(parameterIndex, (int)sqlType.getVendorTypeNumber(), typeName);
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType) throws SQLException {
        this.registerOutParameter(parameterName, (int)sqlType.getVendorTypeNumber());
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterName, (int)sqlType.getVendorTypeNumber(), scale);
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType, String typeName) throws SQLException {
        this.registerOutParameter(parameterName, (int)sqlType.getVendorTypeNumber(), typeName);
    }

    protected CallParameter getParameter(int index) throws SQLException {
        if (index > this.params.size() || index <= 0) {
            throw new SQLException("No parameter with index " + index);
        }
        return this.params.get(index - 1);
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        throw this.exceptionFactory.notSupported("SQLXML not supported");
    }

    @Override
    public void setRowId(String parameterName, RowId rowid) throws SQLException {
        throw this.exceptionFactory.notSupported("RowIDs not supported");
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        this.setString(this.nameToIndex(parameterName), value);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        this.setCharacterStream(this.nameToIndex(parameterName), value, length);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        this.setCharacterStream(this.nameToIndex(parameterName), value);
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        this.setClob(this.nameToIndex(parameterName), (Clob)value);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        this.setClob(this.nameToIndex(parameterName), reader, length);
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        this.setClob(this.nameToIndex(parameterName), reader);
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        this.setClob(this.nameToIndex(parameterName), reader, length);
    }

    @Override
    public void setClob(String parameterName, Clob clob) throws SQLException {
        this.setClob(this.nameToIndex(parameterName), clob);
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        this.setClob(this.nameToIndex(parameterName), reader);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        this.setBlob(this.nameToIndex(parameterName), inputStream, length);
    }

    @Override
    public void setBlob(String parameterName, Blob blob) throws SQLException {
        this.setBlob(this.nameToIndex(parameterName), blob);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        this.setBlob(this.nameToIndex(parameterName), inputStream);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream inputStream, long length) throws SQLException {
        this.setAsciiStream(this.nameToIndex(parameterName), inputStream, length);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream inputStream, int length) throws SQLException {
        this.setAsciiStream(this.nameToIndex(parameterName), inputStream, length);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream inputStream) throws SQLException {
        this.setAsciiStream(this.nameToIndex(parameterName), inputStream);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream inputStream, long length) throws SQLException {
        this.setBinaryStream(this.nameToIndex(parameterName), inputStream, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream inputStream) throws SQLException {
        this.setBinaryStream(this.nameToIndex(parameterName), inputStream);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream inputStream, int length) throws SQLException {
        this.setBinaryStream(this.nameToIndex(parameterName), inputStream, length);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        this.setCharacterStream(this.nameToIndex(parameterName), reader, length);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        this.setCharacterStream(this.nameToIndex(parameterName), reader);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.setCharacterStream(this.nameToIndex(parameterName), reader, length);
    }

    @Override
    public void setURL(String parameterName, URL url) throws SQLException {
        this.setURL(this.nameToIndex(parameterName), url);
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.setNull(this.nameToIndex(parameterName), sqlType);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.setNull(this.nameToIndex(parameterName), sqlType, typeName);
    }

    @Override
    public void setBoolean(String parameterName, boolean booleanValue) throws SQLException {
        this.setBoolean(this.nameToIndex(parameterName), booleanValue);
    }

    @Override
    public void setByte(String parameterName, byte byteValue) throws SQLException {
        this.setByte(this.nameToIndex(parameterName), byteValue);
    }

    @Override
    public void setShort(String parameterName, short shortValue) throws SQLException {
        this.setShort(this.nameToIndex(parameterName), shortValue);
    }

    @Override
    public void setInt(String parameterName, int intValue) throws SQLException {
        this.setInt(this.nameToIndex(parameterName), intValue);
    }

    @Override
    public void setLong(String parameterName, long longValue) throws SQLException {
        this.setLong(this.nameToIndex(parameterName), longValue);
    }

    @Override
    public void setFloat(String parameterName, float floatValue) throws SQLException {
        this.setFloat(this.nameToIndex(parameterName), floatValue);
    }

    @Override
    public void setDouble(String parameterName, double doubleValue) throws SQLException {
        this.setDouble(this.nameToIndex(parameterName), doubleValue);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal bigDecimal) throws SQLException {
        this.setBigDecimal(this.nameToIndex(parameterName), bigDecimal);
    }

    @Override
    public void setString(String parameterName, String stringValue) throws SQLException {
        this.setString(this.nameToIndex(parameterName), stringValue);
    }

    @Override
    public void setBytes(String parameterName, byte[] bytes) throws SQLException {
        this.setBytes(this.nameToIndex(parameterName), bytes);
    }

    @Override
    public void setDate(String parameterName, Date date) throws SQLException {
        this.setDate(this.nameToIndex(parameterName), date);
    }

    @Override
    public void setDate(String parameterName, Date date, Calendar cal) throws SQLException {
        this.setDate(this.nameToIndex(parameterName), date, cal);
    }

    @Override
    public void setTime(String parameterName, Time time) throws SQLException {
        this.setTime(this.nameToIndex(parameterName), time);
    }

    @Override
    public void setTime(String parameterName, Time time, Calendar cal) throws SQLException {
        this.setTime(this.nameToIndex(parameterName), time, cal);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp timestamp) throws SQLException {
        this.setTimestamp(this.nameToIndex(parameterName), timestamp);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp timestamp, Calendar cal) throws SQLException {
        this.setTimestamp(this.nameToIndex(parameterName), timestamp, cal);
    }

    @Override
    public void setObject(String parameterName, Object obj, int targetSqlType, int scale) throws SQLException {
        this.setObject(this.nameToIndex(parameterName), obj, targetSqlType, scale);
    }

    @Override
    public void setObject(String parameterName, Object obj, int targetSqlType) throws SQLException {
        this.setObject(this.nameToIndex(parameterName), obj, targetSqlType);
    }

    @Override
    public void setObject(String parameterName, Object obj) throws SQLException {
        this.setObject(this.nameToIndex(parameterName), obj);
    }

    @Override
    public void setObject(String parameterName, Object obj, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(this.nameToIndex(parameterName), obj, (int)targetSqlType.getVendorTypeNumber(), scaleOrLength);
    }

    @Override
    public void setObject(String parameterName, Object obj, SQLType targetSqlType) throws SQLException {
        this.setObject(this.nameToIndex(parameterName), obj, (int)targetSqlType.getVendorTypeNumber());
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        super.setNull(this.checkAndMinusForObFunction(parameterIndex), sqlType);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        super.setBoolean(this.checkAndMinusForObFunction(parameterIndex), x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        super.setByte(this.checkAndMinusForObFunction(parameterIndex), x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        super.setShort(this.checkAndMinusForObFunction(parameterIndex), x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        super.setInt(this.checkAndMinusForObFunction(parameterIndex), x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        super.setLong(this.checkAndMinusForObFunction(parameterIndex), x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        super.setFloat(this.checkAndMinusForObFunction(parameterIndex), x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        super.setDouble(this.checkAndMinusForObFunction(parameterIndex), x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        super.setBigDecimal(this.checkAndMinusForObFunction(parameterIndex), x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        super.setString(this.checkAndMinusForObFunction(parameterIndex), x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        super.setBytes(this.checkAndMinusForObFunction(parameterIndex), x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        super.setDate(this.checkAndMinusForObFunction(parameterIndex), x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        super.setTime(this.checkAndMinusForObFunction(parameterIndex), x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        super.setTimestamp(this.checkAndMinusForObFunction(parameterIndex), x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        super.setAsciiStream(this.checkAndMinusForObFunction(parameterIndex), x, length);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        super.setUnicodeStream(this.checkAndMinusForObFunction(parameterIndex), x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        super.setBinaryStream(this.checkAndMinusForObFunction(parameterIndex), x, length);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        super.setObject(this.checkAndMinusForObFunction(parameterIndex), x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        super.setObject(this.checkAndMinusForObFunction(parameterIndex), x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        super.setCharacterStream(this.checkAndMinusForObFunction(parameterIndex), reader, length);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        super.setRef(this.checkAndMinusForObFunction(parameterIndex), x);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        super.setBlob(this.checkAndMinusForObFunction(parameterIndex), x);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        super.setClob(this.checkAndMinusForObFunction(parameterIndex), x);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        super.setArray(this.checkAndMinusForObFunction(parameterIndex), x);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        super.setDate(this.checkAndMinusForObFunction(parameterIndex), x, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        super.setTime(this.checkAndMinusForObFunction(parameterIndex), x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        super.setTimestamp(this.checkAndMinusForObFunction(parameterIndex), x, cal);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        super.setNull(this.checkAndMinusForObFunction(parameterIndex), sqlType, typeName);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        super.setURL(this.checkAndMinusForObFunction(parameterIndex), x);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        super.setRowId(this.checkAndMinusForObFunction(parameterIndex), x);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        super.setNString(this.checkAndMinusForObFunction(parameterIndex), value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        super.setNCharacterStream(this.checkAndMinusForObFunction(parameterIndex), value, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        super.setNClob(this.checkAndMinusForObFunction(parameterIndex), value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        super.setClob(this.checkAndMinusForObFunction(parameterIndex), reader, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        super.setBlob(this.checkAndMinusForObFunction(parameterIndex), inputStream, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        super.setNClob(this.checkAndMinusForObFunction(parameterIndex), reader, length);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        super.setSQLXML(this.checkAndMinusForObFunction(parameterIndex), xmlObject);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        super.setObject(this.checkAndMinusForObFunction(parameterIndex), x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        super.setAsciiStream(this.checkAndMinusForObFunction(parameterIndex), x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        super.setBinaryStream(this.checkAndMinusForObFunction(parameterIndex), x, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        super.setCharacterStream(this.checkAndMinusForObFunction(parameterIndex), reader, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        super.setAsciiStream(this.checkAndMinusForObFunction(parameterIndex), x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        super.setBinaryStream(this.checkAndMinusForObFunction(parameterIndex), x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        super.setCharacterStream(this.checkAndMinusForObFunction(parameterIndex), reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        super.setNCharacterStream(this.checkAndMinusForObFunction(parameterIndex), value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        super.setClob(this.checkAndMinusForObFunction(parameterIndex), reader);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        super.setBlob(this.checkAndMinusForObFunction(parameterIndex), inputStream);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        super.setNClob(this.checkAndMinusForObFunction(parameterIndex), reader);
    }

    private int checkAndMinusForObFunction(int parameterIndex) {
        return parameterIndex;
    }
}

