/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.ds.common;

import com.kingbase8.ds.KBConnectionPoolDataSource;
import com.kingbase8.ds.KBPoolingDataSource;
import com.kingbase8.ds.KBSimpleDataSource;
import com.kingbase8.ds.common.BaseDataSource;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class KBObjectFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference ref = (Reference)obj;
        String className = ref.getClassName();
        if (className.equals("com.kingbase8.ds.KBSimpleDataSource") || className.equals("com.kingbase8.jdbc2.optional.SimpleDataSource") || className.equals("com.kingbase8.jdbc3.Jdbc3SimpleDataSource")) {
            return this.loadSimpleDataSource(ref);
        }
        if (className.equals("com.kingbase8.ds.KBConnectionPoolDataSource") || className.equals("com.kingbase8.jdbc2.optional.ConnectionPool") || className.equals("com.kingbase8.jdbc3.Jdbc3ConnectionPool")) {
            return this.loadConnectionPool(ref);
        }
        if (className.equals("com.kingbase8.ds.KBPoolingDataSource") || className.equals("com.kingbase8.jdbc2.optional.PoolingDataSource") || className.equals("com.kingbase8.jdbc3.Jdbc3PoolingDataSource")) {
            return this.loadPoolingDataSource(ref);
        }
        return null;
    }

    private Object loadPoolingDataSource(Reference ref) {
        String max;
        String name = this.getProperty(ref, "dataSourceName");
        KBPoolingDataSource pds = KBPoolingDataSource.getDataSource(name);
        if (pds != null) {
            return pds;
        }
        pds = new KBPoolingDataSource();
        pds.setDataSourceName(name);
        this.loadBaseDataSource(pds, ref);
        String min = this.getProperty(ref, "initialConnections");
        if (min != null) {
            pds.setInitialConnections(Integer.parseInt(min));
        }
        if ((max = this.getProperty(ref, "maxConnections")) != null) {
            pds.setMaxConnections(Integer.parseInt(max));
        }
        return pds;
    }

    private Object loadSimpleDataSource(Reference ref) {
        KBSimpleDataSource ds = new KBSimpleDataSource();
        return this.loadBaseDataSource(ds, ref);
    }

    private Object loadConnectionPool(Reference ref) {
        KBConnectionPoolDataSource cp = new KBConnectionPoolDataSource();
        return this.loadBaseDataSource(cp, ref);
    }

    protected Object loadBaseDataSource(BaseDataSource ds, Reference ref) {
        ds.setFromReference(ref);
        return ds;
    }

    protected String getProperty(Reference ref, String s) {
        RefAddr addr = ref.get(s);
        if (addr == null) {
            return null;
        }
        return (String)addr.getContent();
    }
}

