/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core.v3.replication;

import com.kingbase8.copy.CopyDual;
import com.kingbase8.core.KBStream;
import com.kingbase8.core.QueryExecutor;
import com.kingbase8.core.ReplicationProtocol;
import com.kingbase8.core.v3.replication.V3KBReplicationStream;
import com.kingbase8.replication.KBReplicationStream;
import com.kingbase8.replication.ReplicationType;
import com.kingbase8.replication.fluent.CommonOptions;
import com.kingbase8.replication.fluent.logical.LogicalReplicationOptions;
import com.kingbase8.replication.fluent.physical.PhysicalReplicationOptions;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.LOGGER;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;

public class V3ReplicationProtocol
implements ReplicationProtocol {
    private final QueryExecutor queryExecutor;
    private final KBStream pgStream;

    public V3ReplicationProtocol(QueryExecutor queryExecutor, KBStream pgStream) {
        this.queryExecutor = queryExecutor;
        this.pgStream = pgStream;
    }

    @Override
    public KBReplicationStream startLogical(LogicalReplicationOptions options) throws SQLException {
        String query = this.createStartLogicalQuery(options);
        return this.initializeReplication(query, options, ReplicationType.LOGICAL);
    }

    @Override
    public KBReplicationStream startPhysical(PhysicalReplicationOptions options) throws SQLException {
        String query = this.createStartPhysicalQuery(options);
        return this.initializeReplication(query, options, ReplicationType.PHYSICAL);
    }

    private KBReplicationStream initializeReplication(String query, CommonOptions options, ReplicationType replicationType) throws SQLException {
        LOGGER.log(Level.FINEST, " FE=> StartReplication(query: {0})", query);
        this.configureSocketTimeout(options);
        CopyDual copyDual = (CopyDual)this.queryExecutor.startCopy(query, true);
        return new V3KBReplicationStream(copyDual, options.getStartLSNPosition(), options.getStatusInterval(), replicationType);
    }

    private String createStartPhysicalQuery(PhysicalReplicationOptions options) {
        StringBuilder builder = new StringBuilder();
        builder.append("START_REPLICATION");
        if (options.getSlotName() != null) {
            builder.append(" SLOT ").append(options.getSlotName());
        }
        builder.append(" PHYSICAL ").append(options.getStartLSNPosition().asString());
        return builder.toString();
    }

    private String createStartLogicalQuery(LogicalReplicationOptions options) {
        StringBuilder builder = new StringBuilder();
        builder.append("START_REPLICATION SLOT ").append(options.getSlotName()).append(" LOGICAL ").append(options.getStartLSNPosition().asString());
        Properties slotOptions = options.getSlotOptions();
        if (slotOptions.isEmpty()) {
            return builder.toString();
        }
        builder.append(" (");
        boolean isFirst = true;
        for (String name : slotOptions.stringPropertyNames()) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(", ");
            }
            builder.append('\"').append(name).append('\"').append(" ").append('\'').append(slotOptions.getProperty(name)).append('\'');
        }
        builder.append(")");
        return builder.toString();
    }

    private void configureSocketTimeout(CommonOptions options) throws KSQLException {
        if (options.getStatusInterval() == 0) {
            return;
        }
        try {
            int previousTimeOut = this.pgStream.getSocket().getSoTimeout();
            int minimalTimeOut = previousTimeOut > 0 ? Math.min(previousTimeOut, options.getStatusInterval()) : options.getStatusInterval();
            if (this.pgStream.isUseDispatch()) {
                this.pgStream.getSocket().setSoTimeout(minimalTimeOut);
                this.pgStream.setSocketTimeout(1);
                LOGGER.log(Level.INFO, "socketTimeout is " + minimalTimeOut, new Object[0]);
            } else {
                this.pgStream.getSocket().setSoTimeout(minimalTimeOut);
            }
            this.pgStream.setMinStreamAvailableCheckDelay(0);
        }
        catch (IOException ioe) {
            throw new KSQLException(GT.tr("The connection attempt failed.", new Object[0]), KSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)ioe);
        }
    }
}

